/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexLifecycleStrategyName;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexScopeBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexingBackendContext;
import org.hibernate.search.backend.elasticsearch.index.management.impl.ElasticsearchIndexLifecycleStrategy;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkPlan;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexManagerImpl
implements IndexManagerImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchIndexManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<ElasticsearchIndexLifecycleStrategyName> LIFECYCLE_STRATEGY = ConfigurationProperty.forKey((String)"lifecycle.strategy").as(ElasticsearchIndexLifecycleStrategyName.class, ElasticsearchIndexLifecycleStrategyName::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_STRATEGY).build();
    private static final ConfigurationProperty<ElasticsearchIndexStatus> MANAGEMENT_REQUIRED_STATUS = ConfigurationProperty.forKey((String)"lifecycle.minimal_required_status").as(ElasticsearchIndexStatus.class, ElasticsearchIndexStatus::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_MINIMAL_REQUIRED_STATUS).build();
    private static final ConfigurationProperty<Integer> MANAGEMENT_REQUIRED_STATUS_WAIT_TIMEOUT = ConfigurationProperty.forKey((String)"lifecycle.minimal_required_status_wait_timeout").asInteger().withDefault((Object)10000).build();
    private final IndexingBackendContext indexingBackendContext;
    private final SearchBackendContext searchBackendContext;
    private final String hibernateSearchIndexName;
    private final URLEncodedString elasticsearchIndexName;
    private final ElasticsearchIndexModel model;
    private final ElasticsearchWorkOrchestratorImplementor serialOrchestrator;
    private final ElasticsearchWorkOrchestratorImplementor parallelOrchestrator;
    private final ElasticsearchIndexAdministrationClient administrationClient;
    private ElasticsearchIndexLifecycleStrategy lifecycleStrategy;

    ElasticsearchIndexManagerImpl(IndexingBackendContext indexingBackendContext, SearchBackendContext searchBackendContext, String hibernateSearchIndexName, URLEncodedString elasticsearchIndexName, ElasticsearchIndexModel model) {
        this.indexingBackendContext = indexingBackendContext;
        this.searchBackendContext = searchBackendContext;
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.model = model;
        this.parallelOrchestrator = indexingBackendContext.createParallelOrchestrator(elasticsearchIndexName.original);
        this.serialOrchestrator = indexingBackendContext.createSerialOrchestrator(elasticsearchIndexName.original);
        this.administrationClient = indexingBackendContext.createAdministrationClient(elasticsearchIndexName, model);
    }

    public void start(IndexManagerStartContext context) {
        try {
            this.lifecycleStrategy = this.createLifecycleStrategy(context.getConfigurationPropertySource());
            this.lifecycleStrategy.onStart(this.administrationClient, context);
            this.serialOrchestrator.start();
            this.parallelOrchestrator.start();
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)this.parallelOrchestrator).push((AutoCloseable)this.serialOrchestrator);
            throw e;
        }
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestratorImplementor::close, (Object)this.serialOrchestrator);
            closer.push(ElasticsearchWorkOrchestratorImplementor::close, (Object)this.parallelOrchestrator);
            closer.push(strategy -> strategy.onStop(this.administrationClient), (Object)this.lifecycleStrategy);
        }
        catch (IOException e) {
            throw log.failedToShutdownIndexManager(this.hibernateSearchIndexName, e, this.indexingBackendContext.getEventContext());
        }
    }

    public ElasticsearchIndexModel getModel() {
        return this.model;
    }

    public IndexWorkPlan<ElasticsearchDocumentObjectBuilder> createWorkPlan(SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.indexingBackendContext.createWorkPlan(this.serialOrchestrator, this.elasticsearchIndexName, refreshStrategy, sessionContext);
    }

    public IndexDocumentWorkExecutor<ElasticsearchDocumentObjectBuilder> createDocumentWorkExecutor(SessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.indexingBackendContext.createDocumentWorkExecutor(this.parallelOrchestrator, this.elasticsearchIndexName, sessionContext);
    }

    public IndexWorkExecutor createWorkExecutor(DetachedSessionContextImplementor sessionContext) {
        return this.indexingBackendContext.createWorkExecutor(this.parallelOrchestrator, this.elasticsearchIndexName, sessionContext);
    }

    public IndexScopeBuilder createScopeBuilder(MappingContextImplementor mappingContext) {
        return new ElasticsearchIndexScopeBuilder(this.searchBackendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof ElasticsearchIndexScopeBuilder)) {
            throw log.cannotMixElasticsearchScopeWithOtherType(builder, this, this.searchBackendContext.getEventContext());
        }
        ElasticsearchIndexScopeBuilder esBuilder = (ElasticsearchIndexScopeBuilder)builder;
        esBuilder.add(this.searchBackendContext, this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.hibernateSearchIndexName + "elasticsearchName=" + this.elasticsearchIndexName.original + "]";
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, ElasticsearchIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.indexingBackendContext.getEventContext().append(EventContexts.fromIndexName((String)this.hibernateSearchIndexName));
    }

    private ElasticsearchIndexLifecycleStrategy createLifecycleStrategy(ConfigurationPropertySource propertySource) {
        return new ElasticsearchIndexLifecycleStrategy((ElasticsearchIndexLifecycleStrategyName)((Object)LIFECYCLE_STRATEGY.get(propertySource)), new ElasticsearchIndexLifecycleExecutionOptions((ElasticsearchIndexStatus)((Object)MANAGEMENT_REQUIRED_STATUS.get(propertySource)), (Integer)MANAGEMENT_REQUIRED_STATUS_WAIT_TIMEOUT.get(propertySource)));
    }
}

