/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateBuilder;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBooleanPredicateBuilder
extends AbstractElasticsearchSearchPredicateBuilder
implements BooleanPredicateBuilder<ElasticsearchSearchPredicateBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<JsonObject> MUST_ACCESSOR = JsonAccessor.root().property("must").asObject();
    private static final JsonAccessor<JsonObject> MUST_NOT_ACCESSOR = JsonAccessor.root().property("must_not").asObject();
    private static final JsonAccessor<JsonObject> SHOULD_ACCESSOR = JsonAccessor.root().property("should").asObject();
    private static final JsonAccessor<JsonObject> FILTER_ACCESSOR = JsonAccessor.root().property("filter").asObject();
    private static final JsonAccessor<String> MINIMUM_SHOULD_MATCH_ACCESSOR = JsonAccessor.root().property("minimum_should_match").asString();
    private List<ElasticsearchSearchPredicateBuilder> mustClauseBuilders;
    private List<ElasticsearchSearchPredicateBuilder> mustNotClauseBuilders;
    private List<ElasticsearchSearchPredicateBuilder> shouldClauseBuilders;
    private List<ElasticsearchSearchPredicateBuilder> filterClauseBuilders;
    private Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints;

    ElasticsearchBooleanPredicateBuilder() {
    }

    public void must(ElasticsearchSearchPredicateBuilder clauseBuilder) {
        if (this.mustClauseBuilders == null) {
            this.mustClauseBuilders = new ArrayList<ElasticsearchSearchPredicateBuilder>();
        }
        this.mustClauseBuilders.add(clauseBuilder);
    }

    public void mustNot(ElasticsearchSearchPredicateBuilder clauseBuilder) {
        if (this.mustNotClauseBuilders == null) {
            this.mustNotClauseBuilders = new ArrayList<ElasticsearchSearchPredicateBuilder>();
        }
        this.mustNotClauseBuilders.add(clauseBuilder);
    }

    public void should(ElasticsearchSearchPredicateBuilder clauseBuilder) {
        if (this.shouldClauseBuilders == null) {
            this.shouldClauseBuilders = new ArrayList<ElasticsearchSearchPredicateBuilder>();
        }
        this.shouldClauseBuilders.add(clauseBuilder);
    }

    public void filter(ElasticsearchSearchPredicateBuilder clauseBuilder) {
        if (this.filterClauseBuilders == null) {
            this.filterClauseBuilders = new ArrayList<ElasticsearchSearchPredicateBuilder>();
        }
        this.filterClauseBuilders.add(clauseBuilder);
    }

    public void minimumShouldMatchNumber(int ignoreConstraintCeiling, int matchingClausesNumber) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(matchingClausesNumber, null));
    }

    public void minimumShouldMatchPercent(int ignoreConstraintCeiling, int matchingClausesPercent) {
        this.addMinimumShouldMatchConstraint(ignoreConstraintCeiling, new MinimumShouldMatchConstraint(null, matchingClausesPercent));
    }

    private void addMinimumShouldMatchConstraint(int ignoreConstraintCeiling, MinimumShouldMatchConstraint constraint) {
        MinimumShouldMatchConstraint previous;
        if (this.minimumShouldMatchConstraints == null) {
            this.minimumShouldMatchConstraints = new TreeMap<Integer, MinimumShouldMatchConstraint>();
        }
        if ((previous = this.minimumShouldMatchConstraints.put(ignoreConstraintCeiling, constraint)) != null) {
            throw log.minimumShouldMatchConflictingConstraints(ignoreConstraintCeiling);
        }
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        this.contributeClauses(context, innerObject, MUST_ACCESSOR, this.mustClauseBuilders);
        this.contributeClauses(context, innerObject, MUST_NOT_ACCESSOR, this.mustNotClauseBuilders);
        this.contributeClauses(context, innerObject, SHOULD_ACCESSOR, this.shouldClauseBuilders);
        this.contributeClauses(context, innerObject, FILTER_ACCESSOR, this.filterClauseBuilders);
        if (this.minimumShouldMatchConstraints == null && this.hasAtLeastOneMustOrFilterPredicate()) {
            this.minimumShouldMatchNumber(0, 0);
        }
        if (this.minimumShouldMatchConstraints != null) {
            MINIMUM_SHOULD_MATCH_ACCESSOR.set(innerObject, this.formatMinimumShouldMatchConstraints(this.minimumShouldMatchConstraints));
        }
        outerObject.add("bool", (JsonElement)innerObject);
        return outerObject;
    }

    private boolean hasAtLeastOneMustOrFilterPredicate() {
        return this.mustClauseBuilders != null || this.filterClauseBuilders != null;
    }

    private void contributeClauses(ElasticsearchSearchPredicateContext context, JsonObject innerObject, JsonAccessor<JsonObject> occurAccessor, List<ElasticsearchSearchPredicateBuilder> clauseBuilders) {
        if (clauseBuilders == null) {
            return;
        }
        for (ElasticsearchSearchPredicateBuilder clauseBuilder : clauseBuilders) {
            occurAccessor.add(innerObject, clauseBuilder.build(context));
        }
    }

    private String formatMinimumShouldMatchConstraints(Map<Integer, MinimumShouldMatchConstraint> minimumShouldMatchConstraints) {
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<Integer, MinimumShouldMatchConstraint>> iterator = minimumShouldMatchConstraints.entrySet().iterator();
        Map.Entry<Integer, MinimumShouldMatchConstraint> entry = iterator.next();
        Integer ignoreConstraintCeiling = entry.getKey();
        MinimumShouldMatchConstraint constraint = entry.getValue();
        if (ignoreConstraintCeiling.equals(0) && minimumShouldMatchConstraints.size() == 1) {
            constraint.appendTo(builder, null);
            return builder.toString();
        }
        entry.getValue().appendTo(builder, ignoreConstraintCeiling);
        while (iterator.hasNext()) {
            entry = iterator.next();
            ignoreConstraintCeiling = entry.getKey();
            constraint = entry.getValue();
            builder.append(' ');
            constraint.appendTo(builder, ignoreConstraintCeiling);
        }
        return builder.toString();
    }

    private static final class MinimumShouldMatchConstraint {
        private final Integer matchingClausesNumber;
        private final Integer matchingClausesPercent;

        MinimumShouldMatchConstraint(Integer matchingClausesNumber, Integer matchingClausesPercent) {
            this.matchingClausesNumber = matchingClausesNumber;
            this.matchingClausesPercent = matchingClausesPercent;
        }

        void appendTo(StringBuilder builder, Integer ignoreConstraintCeiling) {
            if (ignoreConstraintCeiling != null) {
                builder.append(ignoreConstraintCeiling).append('<');
            }
            if (this.matchingClausesNumber != null) {
                builder.append(this.matchingClausesNumber);
            } else {
                builder.append(this.matchingClausesPercent).append('%');
            }
        }
    }
}

