/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.util.impl.ElasticsearchFields;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaBuildContext;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexSchemaFieldNodeBuilder<F>
implements IndexSchemaFieldOptionsStep<ElasticsearchIndexSchemaFieldNodeBuilder<F>, IndexFieldReference<F>>,
ElasticsearchIndexSchemaNodeContributor,
IndexSchemaBuildContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexSchemaObjectNodeBuilder parent;
    private final String relativeFieldName;
    private final String absoluteFieldPath;
    private final ElasticsearchIndexFieldType<F> type;
    private boolean multiValued = false;
    private ElasticsearchIndexFieldReference<F> reference;

    ElasticsearchIndexSchemaFieldNodeBuilder(AbstractElasticsearchIndexSchemaObjectNodeBuilder parent, String relativeFieldName, ElasticsearchIndexFieldType<F> type) {
        this.parent = parent;
        this.relativeFieldName = relativeFieldName;
        this.absoluteFieldPath = ElasticsearchFields.compose(parent.getAbsolutePath(), relativeFieldName);
        this.type = type;
    }

    public EventContext getEventContext() {
        return this.parent.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public ElasticsearchIndexSchemaFieldNodeBuilder<F> multiValued() {
        this.multiValued = true;
        return this;
    }

    public IndexFieldReference<F> toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.getEventContext());
        }
        UnknownTypeJsonAccessor jsonAccessor = JsonAccessor.root().property(this.relativeFieldName);
        this.reference = new ElasticsearchIndexFieldReference(jsonAccessor);
        return this.reference;
    }

    @Override
    public void contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode, AbstractTypeMapping parentMapping) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.getEventContext());
        }
        ElasticsearchIndexSchemaFieldNode<F> fieldNode = this.type.addField(collector, parentNode, parentMapping, this.relativeFieldName, this.multiValued);
        this.reference.enable(fieldNode);
    }
}

