/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import com.google.gson.Gson;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorProvider;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexDocumentWorkExecutor;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexWorkExecutor;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.ElasticsearchIndexWorkPlan;
import org.hibernate.search.backend.elasticsearch.work.execution.impl.WorkExecutionBackendContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkPlan;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.DetachedSessionContextImplementor;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexManagerBackendContext
implements SearchBackendContext,
WorkExecutionBackendContext {
    private final EventContext eventContext;
    private final ElasticsearchLink link;
    private final Gson userFacingGson;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestratorProvider orchestratorProvider;
    private final ElasticsearchWorkOrchestrator queryOrchestrator;
    private final SearchProjectionBackendContext searchProjectionBackendContext;
    private final DocumentReferenceExtractorHelper documentReferenceExtractorHelper;

    public IndexManagerBackendContext(EventContext eventContext, ElasticsearchLink link, Gson userFacingGson, Function<String, String> indexNameConverter, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestratorProvider orchestratorProvider, ElasticsearchWorkOrchestrator queryOrchestrator) {
        this.eventContext = eventContext;
        this.link = link;
        this.userFacingGson = userFacingGson;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestratorProvider = orchestratorProvider;
        this.queryOrchestrator = queryOrchestrator;
        this.documentReferenceExtractorHelper = new DocumentReferenceExtractorHelper(indexNameConverter, multiTenancyStrategy);
        this.searchProjectionBackendContext = new SearchProjectionBackendContext(this.documentReferenceExtractorHelper, userFacingGson);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext + "]";
    }

    @Override
    public IndexWorkPlan<ElasticsearchDocumentObjectBuilder> createWorkPlan(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, DocumentRefreshStrategy refreshStrategy, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexWorkPlan(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexName, refreshStrategy, sessionContext);
    }

    @Override
    public IndexDocumentWorkExecutor<ElasticsearchDocumentObjectBuilder> createDocumentWorkExecutor(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, SessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexDocumentWorkExecutor(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexName, sessionContext);
    }

    @Override
    public IndexWorkExecutor createWorkExecutor(ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, DetachedSessionContextImplementor sessionContext) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchIndexWorkExecutor(this.link.getWorkBuilderFactory(), this.multiTenancyStrategy, orchestrator, indexName, sessionContext);
    }

    @Override
    public DocumentReferenceExtractorHelper getDocumentReferenceExtractorHelper() {
        return this.documentReferenceExtractorHelper;
    }

    @Override
    public SearchProjectionBackendContext getSearchProjectionBackendContext() {
        return this.searchProjectionBackendContext;
    }

    @Override
    public ElasticsearchSearchContext createSearchContext(MappingContextImplementor mappingContext, ElasticsearchScopeModel scopeModel) {
        return new ElasticsearchSearchContext(mappingContext, this.userFacingGson, this.multiTenancyStrategy, scopeModel);
    }

    @Override
    public <H> ElasticsearchSearchQueryBuilder<H> createSearchQueryBuilder(ElasticsearchSearchContext searchContext, SessionContextImplementor sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        this.multiTenancyStrategy.checkTenantId(sessionContext.getTenantIdentifier(), this.eventContext);
        return new ElasticsearchSearchQueryBuilder<H>(this.link.getWorkBuilderFactory(), this.link.getSearchResultExtractorFactory(), this.queryOrchestrator, this.multiTenancyStrategy, searchContext, sessionContext, loadingContextBuilder, rootProjection);
    }

    EventContext getEventContext() {
        return this.eventContext;
    }

    ElasticsearchIndexAdministrationClient createAdministrationClient(URLEncodedString indexName, ElasticsearchIndexModel model) {
        IndexMetadata metadata = new IndexMetadata();
        metadata.setName(model.getElasticsearchIndexName());
        metadata.setSettings(model.getSettings());
        metadata.setMapping(model.getMapping());
        return new ElasticsearchIndexAdministrationClient(this.link, this.orchestratorProvider.getRootParallelOrchestrator(), indexName, metadata);
    }

    ElasticsearchWorkOrchestratorImplementor createSerialOrchestrator(String indexName) {
        return this.orchestratorProvider.createSerialOrchestrator("Elasticsearch serial work orchestrator for index " + indexName);
    }

    ElasticsearchWorkOrchestratorImplementor createParallelOrchestrator(String indexName) {
        return this.orchestratorProvider.createParallelOrchestrator("Elasticsearch parallel work orchestrator for index " + indexName);
    }
}

