/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopeModel;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchScopedIndexFieldComponent;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.IndexSchemaFieldNodeComponentRetrievalStrategy;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeBiFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeListProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeProjectionBuilder;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeTriFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchFieldProjectionBuilderFactory;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.function.TriFunction;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ProjectionBuilderFactoryRetrievalStrategy PROJECTION_BUILDER_FACTORY_RETRIEVAL_STRATEGY = new ProjectionBuilderFactoryRetrievalStrategy();
    private final SearchProjectionBackendContext searchProjectionBackendContext;
    private final ElasticsearchScopeModel scopeModel;

    public ElasticsearchSearchProjectionBuilderFactory(SearchProjectionBackendContext searchProjectionBackendContext, ElasticsearchScopeModel scopeModel) {
        this.searchProjectionBackendContext = searchProjectionBackendContext;
        this.scopeModel = scopeModel;
    }

    public DocumentReferenceProjectionBuilder documentReference() {
        return this.searchProjectionBackendContext.createDocumentReferenceProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames());
    }

    public <T> FieldProjectionBuilder<T> field(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        this.scopeModel.getNestedDocumentPath(absoluteFieldPath);
        ElasticsearchScopedIndexFieldComponent<ElasticsearchFieldProjectionBuilderFactory> fieldComponent = this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PROJECTION_BUILDER_FACTORY_RETRIEVAL_STRATEGY);
        switch (convert) {
            case NO: {
                break;
            }
            default: {
                fieldComponent.getConverterCompatibilityChecker().failIfNotCompatible();
            }
        }
        return fieldComponent.getComponent().createFieldValueProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames(), absoluteFieldPath, expectedType, convert);
    }

    public <E> EntityProjectionBuilder<E> entity() {
        return this.searchProjectionBackendContext.createEntityProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames());
    }

    public <R> EntityReferenceProjectionBuilder<R> entityReference() {
        return this.searchProjectionBackendContext.createReferenceProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames());
    }

    public ScoreProjectionBuilder score() {
        return this.searchProjectionBackendContext.createScoreProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames());
    }

    public DistanceToFieldProjectionBuilder distance(String absoluteFieldPath, GeoPoint center) {
        return this.scopeModel.getSchemaNodeComponent(absoluteFieldPath, PROJECTION_BUILDER_FACTORY_RETRIEVAL_STRATEGY).getComponent().createDistanceProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames(), absoluteFieldPath, this.scopeModel.getNestedDocumentPath(absoluteFieldPath), center);
    }

    public <P> CompositeProjectionBuilder<P> composite(Function<List<?>, P> transformer, SearchProjection<?> ... projections) {
        ArrayList typedProjections = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            typedProjections.add(this.toImplementation(projection));
        }
        return new ElasticsearchCompositeProjectionBuilder(new ElasticsearchCompositeListProjection<P>(this.scopeModel.getHibernateSearchIndexNames(), transformer, typedProjections));
    }

    public <P1, P> CompositeProjectionBuilder<P> composite(Function<P1, P> transformer, SearchProjection<P1> projection) {
        return new ElasticsearchCompositeProjectionBuilder(new ElasticsearchCompositeFunctionProjection(this.scopeModel.getHibernateSearchIndexNames(), transformer, this.toImplementation(projection)));
    }

    public <P1, P2, P> CompositeProjectionBuilder<P> composite(BiFunction<P1, P2, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        return new ElasticsearchCompositeProjectionBuilder(new ElasticsearchCompositeBiFunctionProjection<P1, P2, P>(this.scopeModel.getHibernateSearchIndexNames(), transformer, this.toImplementation(projection1), this.toImplementation(projection2)));
    }

    public <P1, P2, P3, P> CompositeProjectionBuilder<P> composite(TriFunction<P1, P2, P3, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        return new ElasticsearchCompositeProjectionBuilder(new ElasticsearchCompositeTriFunctionProjection<P1, P2, P3, P>(this.scopeModel.getHibernateSearchIndexNames(), transformer, this.toImplementation(projection1), this.toImplementation(projection2), this.toImplementation(projection3)));
    }

    public SearchProjectionBuilder<String> source() {
        return this.searchProjectionBackendContext.createSourceProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames());
    }

    public SearchProjectionBuilder<String> explanation() {
        return this.searchProjectionBackendContext.createExplanationProjectionBuilder(this.scopeModel.getHibernateSearchIndexNames());
    }

    public <T> ElasticsearchSearchProjection<?, T> toImplementation(SearchProjection<T> projection) {
        if (!(projection instanceof ElasticsearchSearchProjection)) {
            throw log.cannotMixElasticsearchSearchQueryWithOtherProjections(projection);
        }
        ElasticsearchSearchProjection casted = (ElasticsearchSearchProjection)projection;
        if (!this.scopeModel.getHibernateSearchIndexNames().equals(casted.getIndexNames())) {
            throw log.projectionDefinedOnDifferentIndexes(projection, casted.getIndexNames(), this.scopeModel.getHibernateSearchIndexNames());
        }
        return casted;
    }

    private static class ProjectionBuilderFactoryRetrievalStrategy
    implements IndexSchemaFieldNodeComponentRetrievalStrategy<ElasticsearchFieldProjectionBuilderFactory> {
        private ProjectionBuilderFactoryRetrievalStrategy() {
        }

        @Override
        public ElasticsearchFieldProjectionBuilderFactory extractComponent(ElasticsearchIndexSchemaFieldNode<?> schemaNode) {
            return schemaNode.getProjectionBuilderFactory();
        }

        @Override
        public boolean hasCompatibleCodec(ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2) {
            return component1.hasCompatibleCodec(component2);
        }

        @Override
        public boolean hasCompatibleConverter(ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2) {
            return component1.hasCompatibleConverter(component2);
        }

        @Override
        public boolean hasCompatibleAnalyzer(ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2) {
            return true;
        }

        @Override
        public SearchException createCompatibilityException(String absoluteFieldPath, ElasticsearchFieldProjectionBuilderFactory component1, ElasticsearchFieldProjectionBuilderFactory component2, EventContext context) {
            return log.conflictingFieldTypesForProjection(absoluteFieldPath, component1, component2, context);
        }
    }
}

