/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class Elasticsearch7SearchResultExtractor<H>
implements ElasticsearchSearchResultExtractor<H> {
    protected static final JsonObjectAccessor HITS_ACCESSOR = JsonAccessor.root().property("hits").asObject();
    private static final JsonAccessor<JsonArray> HITS_HITS_ACCESSOR = HITS_ACCESSOR.property("hits").asArray();
    private static final JsonAccessor<Long> HITS_TOTAL_ACCESSOR = HITS_ACCESSOR.property("total").property("value").asLong();
    private final LoadingContext<?, ?> loadingContext;
    private final ElasticsearchSearchProjection<?, H> rootProjection;
    private final SearchProjectionExtractContext searchProjectionExecutionContext;

    Elasticsearch7SearchResultExtractor(LoadingContext<?, ?> loadingContext, ElasticsearchSearchProjection<?, H> rootProjection, SearchProjectionExtractContext searchProjectionExecutionContext) {
        this.loadingContext = loadingContext;
        this.rootProjection = rootProjection;
        this.searchProjectionExecutionContext = searchProjectionExecutionContext;
    }

    @Override
    public ElasticsearchLoadableSearchResult<H> extract(JsonObject responseBody) {
        ProjectionHitMapper hitMapper = this.loadingContext.getProjectionHitMapper();
        long hitCount = this.extractHitCount(responseBody);
        List<Object> extractedData = hitCount > 0L ? this.extractHits(hitMapper, responseBody) : Collections.emptyList();
        return new ElasticsearchLoadableSearchResult<H>(hitMapper, this.rootProjection, hitCount, extractedData);
    }

    protected long extractHitCount(JsonObject responseBody) {
        return HITS_TOTAL_ACCESSOR.get(responseBody).orElse(0L);
    }

    private List<Object> extractHits(ProjectionHitMapper<?, ?> hitMapper, JsonObject responseBody) {
        JsonArray jsonHits = HITS_HITS_ACCESSOR.get(responseBody).orElseGet(JsonArray::new);
        ArrayList<Object> extractedData = new ArrayList<Object>(jsonHits.size());
        for (JsonElement hit : jsonHits) {
            JsonObject hitObject = hit.getAsJsonObject();
            extractedData.add(this.rootProjection.extract(hitMapper, responseBody, hitObject, this.searchProjectionExecutionContext));
        }
        return extractedData;
    }
}

