/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

public class ElasticsearchLoadableSearchResult<H> {
    private final ProjectionHitMapper<?, ?> projectionHitMapper;
    private final ElasticsearchSearchProjection<?, H> rootProjection;
    private final long hitCount;
    private List<Object> extractedData;

    ElasticsearchLoadableSearchResult(ProjectionHitMapper<?, ?> projectionHitMapper, ElasticsearchSearchProjection<?, H> rootProjection, long hitCount, List<Object> extractedData) {
        this.projectionHitMapper = projectionHitMapper;
        this.rootProjection = rootProjection;
        this.hitCount = hitCount;
        this.extractedData = extractedData;
    }

    ElasticsearchSearchResult<H> loadBlocking(SessionContextImplementor sessionContext) {
        int readIndex;
        SearchProjectionTransformContext transformContext = new SearchProjectionTransformContext(sessionContext);
        LoadingResult loadingResult = this.projectionHitMapper.loadBlocking();
        int writeIndex = 0;
        for (readIndex = 0; readIndex < this.extractedData.size(); ++readIndex) {
            transformContext.reset();
            H transformed = ElasticsearchSearchProjection.transformUnsafe(this.rootProjection, loadingResult, this.extractedData.get(readIndex), transformContext);
            if (transformContext.hasFailedLoad()) continue;
            this.extractedData.set(writeIndex, transformed);
            ++writeIndex;
        }
        if (writeIndex < readIndex) {
            this.extractedData.subList(writeIndex, readIndex).clear();
        }
        List<Object> loadedHits = Collections.unmodifiableList(this.extractedData);
        this.extractedData = null;
        return new ElasticsearchSearchResultImpl<Object>(this.hitCount, loadedHits);
    }
}

