/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.Sortable;

abstract class AbstractElasticsearchScalarFieldTypeOptionsStep<S extends AbstractElasticsearchScalarFieldTypeOptionsStep<? extends S, F>, F>
extends AbstractElasticsearchStandardIndexFieldTypeOptionsStep<S, F> {
    private final String dataType;
    private Sortable sortable = Sortable.DEFAULT;
    protected boolean resolvedSortable;
    private Projectable projectable = Projectable.DEFAULT;
    protected boolean resolvedProjectable;
    private Searchable searchable = Searchable.DEFAULT;
    protected boolean resolvedSearchable;
    protected F indexNullAs;

    AbstractElasticsearchScalarFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType, String dataType) {
        super(buildContext, fieldType);
        this.dataType = dataType;
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return (S)((AbstractElasticsearchScalarFieldTypeOptionsStep)this.thisAsS());
    }

    public S sortable(Sortable sortable) {
        this.sortable = sortable;
        return (S)((AbstractElasticsearchScalarFieldTypeOptionsStep)this.thisAsS());
    }

    public S indexNullAs(F indexNullAs) {
        this.indexNullAs = indexNullAs;
        return (S)((AbstractElasticsearchScalarFieldTypeOptionsStep)this.thisAsS());
    }

    public S searchable(Searchable searchable) {
        this.searchable = searchable;
        return (S)((AbstractElasticsearchScalarFieldTypeOptionsStep)this.thisAsS());
    }

    public final IndexFieldType<F> toIndexFieldType() {
        PropertyMapping mapping = new PropertyMapping();
        mapping.setType(this.dataType);
        this.resolvedSortable = AbstractElasticsearchScalarFieldTypeOptionsStep.resolveDefault(this.sortable);
        this.resolvedProjectable = AbstractElasticsearchScalarFieldTypeOptionsStep.resolveDefault(this.projectable);
        this.resolvedSearchable = AbstractElasticsearchScalarFieldTypeOptionsStep.resolveDefault(this.searchable);
        mapping.setIndex(this.resolvedSearchable);
        mapping.setStore(this.resolvedProjectable);
        mapping.setDocValues(this.resolvedSortable);
        ElasticsearchIndexFieldType<F> indexFieldType = this.toIndexFieldType(mapping);
        if (this.indexNullAs != null) {
            indexFieldType.indexNullAs(this.indexNullAs);
        }
        return indexFieldType;
    }

    protected abstract ElasticsearchIndexFieldType<F> toIndexFieldType(PropertyMapping var1);
}

