/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.document.model.impl.esnative.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.index.settings.impl.esnative.IndexSettings;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.CreateIndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.CreateIndexResult;

public class CreateIndexWork
extends AbstractSimpleElasticsearchWork<CreateIndexResult> {
    private static final String MAPPINGS_PROPERTY = "mappings";

    protected CreateIndexWork(Builder builder) {
        super(builder);
    }

    @Override
    protected CreateIndexResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        int statusCode = response.getStatusCode();
        if (ElasticsearchClientUtils.isSuccessCode(statusCode)) {
            return CreateIndexResult.CREATED;
        }
        return CreateIndexResult.ALREADY_EXISTS;
    }

    public static class Builder
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder>
    implements CreateIndexWorkBuilder {
        private final GsonProvider gsonProvider;
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final Boolean includeTypeName;
        private final JsonObject payload = new JsonObject();

        public static Builder forElasticsearch66AndBelow(GsonProvider gsonProvider, URLEncodedString indexName, URLEncodedString typeName) {
            return new Builder(gsonProvider, indexName, typeName, null);
        }

        public static Builder forElasticsearch67(GsonProvider gsonProvider, URLEncodedString indexName, URLEncodedString typeName) {
            return new Builder(gsonProvider, indexName, typeName, true);
        }

        public static Builder forElasticsearch7AndAbove(GsonProvider gsonProvider, URLEncodedString indexName) {
            return new Builder(gsonProvider, indexName, null, null);
        }

        private Builder(GsonProvider gsonProvider, URLEncodedString indexName, URLEncodedString typeName, Boolean includeTypeName) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.gsonProvider = gsonProvider;
            this.indexName = indexName;
            this.typeName = typeName;
            this.includeTypeName = includeTypeName;
        }

        @Override
        public Builder settings(IndexSettings settings) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            this.payload.add("settings", gson.toJsonTree((Object)settings));
            return this;
        }

        @Override
        public Builder mapping(RootTypeMapping mapping) {
            Gson gson = this.gsonProvider.getGsonNoSerializeNulls();
            if (this.typeName != null) {
                JsonObject mappings = this.payload.getAsJsonObject(CreateIndexWork.MAPPINGS_PROPERTY);
                if (mappings == null) {
                    mappings = new JsonObject();
                    this.payload.add(CreateIndexWork.MAPPINGS_PROPERTY, (JsonElement)mappings);
                }
                mappings.add(this.typeName.original, gson.toJsonTree((Object)mapping));
            } else {
                this.payload.add(CreateIndexWork.MAPPINGS_PROPERTY, gson.toJsonTree((Object)mapping));
            }
            return this;
        }

        @Override
        public Builder ignoreExisting() {
            this.resultAssessor = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorTypes("index_already_exists_exception").build();
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName);
            if (this.includeTypeName != null) {
                builder.param("include_type_name", this.includeTypeName);
            }
            if (this.payload.size() > 0) {
                builder.body(this.payload);
            }
            return builder.build();
        }

        @Override
        public CreateIndexWork build() {
            return new CreateIndexWork(this);
        }
    }
}

