/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.elasticsearch.document.model.esnative.impl;

import java.util.Map;

import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;

public class PropertyMappingJsonAdapterFactory extends AbstractTypeMappingJsonAdapterFactory {

	private static final TypeToken<Map<String, PropertyMapping>> FIELD_MAP_TYPE_TOKEN =
			new TypeToken<Map<String, PropertyMapping>>() {
			};

	@Override
	protected <T> void addFields(Builder<T> builder) {
		super.addFields( builder );
		builder.add( "type", String.class );
		builder.add( "index", Boolean.class );
		builder.add( "norms", Boolean.class );
		builder.add( "docValues", Boolean.class );
		builder.add( "store", Boolean.class );
		builder.add( "nullValue", JsonPrimitive.class );
		builder.add( "fields", FIELD_MAP_TYPE_TOKEN );
		builder.add( "analyzer", String.class );
		builder.add( "normalizer", String.class );
		builder.add( "format", new ElasticsearchFormatJsonAdapter() );
		builder.add( "scalingFactor", Double.class );
		builder.add( "termVector", String.class );
	}
}
