/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.esnative.impl;

import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMappingJsonAdapterFactory;

@JsonAdapter(value=PropertyMappingJsonAdapterFactory.class)
public class PropertyMapping
extends AbstractTypeMapping {
    private String type;
    private Boolean index;
    private Boolean norms;
    @SerializedName(value="doc_values")
    private Boolean docValues;
    private Boolean store;
    @SerializedName(value="null_value")
    private JsonElement nullValue;
    private Map<String, PropertyMapping> fields;
    private String analyzer;
    private String normalizer;
    private List<String> format;
    @SerializedName(value="scaling_factor")
    private Double scalingFactor;
    @SerializedName(value="term_vector")
    private String termVector;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<String> getFormat() {
        return this.format;
    }

    public void setFormat(List<String> format) {
        this.format = format;
    }

    public Boolean getIndex() {
        return this.index;
    }

    public void setIndex(Boolean index) {
        this.index = index;
    }

    public Boolean getNorms() {
        return this.norms;
    }

    public void setNorms(Boolean norms) {
        this.norms = norms;
    }

    public Boolean getDocValues() {
        return this.docValues;
    }

    public void setDocValues(Boolean docValues) {
        this.docValues = docValues;
    }

    public Boolean getStore() {
        return this.store;
    }

    public void setStore(Boolean store) {
        this.store = store;
    }

    public JsonElement getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(JsonElement nullValue) {
        this.nullValue = nullValue;
    }

    public Map<String, PropertyMapping> getFields() {
        return this.fields;
    }

    private Map<String, PropertyMapping> getInitializedFields() {
        if (this.fields == null) {
            this.fields = new TreeMap<String, PropertyMapping>();
        }
        return this.fields;
    }

    public void addField(String name, PropertyMapping mapping) {
        this.getInitializedFields().put(name, mapping);
    }

    public void removeField(String name) {
        this.getInitializedFields().remove(name);
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public String getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(String normalizer) {
        this.normalizer = normalizer;
    }

    public Double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(Double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    public String getTermVector() {
        return this.termVector;
    }

    public void setTermVector(String termVector) {
        this.termVector = termVector;
    }
}

