/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.admin.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaMigrator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.IndexMetadata;
import org.hibernate.search.backend.elasticsearch.index.settings.esnative.impl.IndexSettings;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchSchemaMigratorImpl
implements ElasticsearchSchemaMigrator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchSchemaAccessor schemaAccessor;
    private final ElasticsearchSchemaValidator schemaValidator;

    public ElasticsearchSchemaMigratorImpl(ElasticsearchSchemaAccessor schemaAccessor, ElasticsearchSchemaValidator schemaValidator) {
        this.schemaAccessor = schemaAccessor;
        this.schemaValidator = schemaValidator;
    }

    @Override
    public void migrate(IndexMetadata indexMetadata) {
        URLEncodedString indexName = indexMetadata.getName();
        IndexSettings settings = indexMetadata.getSettings();
        try {
            if (!settings.isEmpty() && !this.schemaValidator.isSettingsValid(indexMetadata)) {
                this.schemaAccessor.closeIndex(indexName);
                try {
                    this.schemaAccessor.updateSettings(indexName, settings);
                }
                catch (RuntimeException mainException) {
                    try {
                        this.schemaAccessor.openIndex(indexName);
                    }
                    catch (RuntimeException e) {
                        mainException.addSuppressed(e);
                    }
                    throw mainException;
                }
                this.schemaAccessor.openIndex(indexName);
            }
            this.schemaAccessor.putMapping(indexName, indexMetadata.getMapping());
        }
        catch (SearchException e) {
            throw log.schemaUpdateFailed(indexName, e.getMessage(), (Exception)((Object)e));
        }
    }
}

