/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchIndexSettings;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexModel;
import org.hibernate.search.backend.elasticsearch.index.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.index.IndexLifecycleStrategyName;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexAdministrationClient;
import org.hibernate.search.backend.elasticsearch.index.admin.impl.ElasticsearchIndexLifecycleExecutionOptions;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexScopeBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.index.management.impl.ElasticsearchIndexLifecycleStrategy;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexManagerImpl
implements IndexManagerImplementor<ElasticsearchDocumentObjectBuilder>,
ElasticsearchIndexManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<IndexLifecycleStrategyName> LIFECYCLE_STRATEGY = ConfigurationProperty.forKey((String)"lifecycle.strategy").as(IndexLifecycleStrategyName.class, IndexLifecycleStrategyName::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_STRATEGY).build();
    private static final ConfigurationProperty<IndexStatus> LIFECYCLE_MINIMAL_REQUIRED_STATUS = ConfigurationProperty.forKey((String)"lifecycle.minimal_required_status").as(IndexStatus.class, IndexStatus::of).withDefault((Object)ElasticsearchIndexSettings.Defaults.LIFECYCLE_MINIMAL_REQUIRED_STATUS).build();
    private static final ConfigurationProperty<Integer> LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT = ConfigurationProperty.forKey((String)"lifecycle.minimal_required_status_wait_timeout").asInteger().withDefault((Object)10000).build();
    private final IndexManagerBackendContext backendContext;
    private final String hibernateSearchIndexName;
    private final URLEncodedString elasticsearchIndexName;
    private final ElasticsearchIndexModel model;
    private final ElasticsearchWorkOrchestratorImplementor serialOrchestrator;
    private final ElasticsearchWorkOrchestratorImplementor parallelOrchestrator;
    private final ElasticsearchIndexAdministrationClient administrationClient;
    private ElasticsearchIndexLifecycleStrategy lifecycleStrategy;

    ElasticsearchIndexManagerImpl(IndexManagerBackendContext backendContext, String hibernateSearchIndexName, URLEncodedString elasticsearchIndexName, ElasticsearchIndexModel model) {
        this.backendContext = backendContext;
        this.hibernateSearchIndexName = hibernateSearchIndexName;
        this.elasticsearchIndexName = elasticsearchIndexName;
        this.model = model;
        this.parallelOrchestrator = backendContext.createParallelOrchestrator(elasticsearchIndexName.original);
        this.serialOrchestrator = backendContext.createSerialOrchestrator(elasticsearchIndexName.original);
        this.administrationClient = backendContext.createAdministrationClient(elasticsearchIndexName, model);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "name=" + this.hibernateSearchIndexName + "elasticsearchName=" + this.elasticsearchIndexName.original + "]";
    }

    public void start(IndexManagerStartContext context) {
        try {
            this.lifecycleStrategy = this.createLifecycleStrategy(context.getConfigurationPropertySource());
            this.lifecycleStrategy.onStart(this.administrationClient, context);
            this.serialOrchestrator.start();
            this.parallelOrchestrator.start();
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)this.parallelOrchestrator).push((AutoCloseable)this.serialOrchestrator);
            throw e;
        }
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchWorkOrchestratorImplementor::close, (Object)this.serialOrchestrator);
            closer.push(ElasticsearchWorkOrchestratorImplementor::close, (Object)this.parallelOrchestrator);
            closer.push(strategy -> strategy.onStop(this.administrationClient), (Object)this.lifecycleStrategy);
        }
        catch (IOException e) {
            throw log.failedToShutdownIndexManager(this.hibernateSearchIndexName, e, this.backendContext.getEventContext());
        }
    }

    public ElasticsearchIndexModel getModel() {
        return this.model;
    }

    public IndexIndexingPlan<ElasticsearchDocumentObjectBuilder> createIndexingPlan(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return this.backendContext.createIndexingPlan(this.serialOrchestrator, this.elasticsearchIndexName, refreshStrategy, sessionContext);
    }

    public IndexIndexer<ElasticsearchDocumentObjectBuilder> createIndexer(BackendSessionContext sessionContext, DocumentCommitStrategy commitStrategy) {
        return this.backendContext.createIndexer(this.parallelOrchestrator, this.elasticsearchIndexName, sessionContext);
    }

    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.backendContext.createWorkspace(this.parallelOrchestrator, this.elasticsearchIndexName, sessionContext);
    }

    public IndexScopeBuilder createScopeBuilder(BackendMappingContext mappingContext) {
        return new ElasticsearchIndexScopeBuilder(this.backendContext, mappingContext, this);
    }

    public void addTo(IndexScopeBuilder builder) {
        if (!(builder instanceof ElasticsearchIndexScopeBuilder)) {
            throw log.cannotMixElasticsearchScopeWithOtherType(builder, this, this.backendContext.getEventContext());
        }
        ElasticsearchIndexScopeBuilder esBuilder = (ElasticsearchIndexScopeBuilder)builder;
        esBuilder.add(this.backendContext, this);
    }

    public IndexManager toAPI() {
        return this;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchIndexManager.class)) {
            return (T)this;
        }
        throw log.indexManagerUnwrappingWithUnknownType(clazz, ElasticsearchIndexManager.class, this.getBackendAndIndexEventContext());
    }

    private EventContext getBackendAndIndexEventContext() {
        return this.backendContext.getEventContext().append(EventContexts.fromIndexName((String)this.hibernateSearchIndexName));
    }

    private ElasticsearchIndexLifecycleStrategy createLifecycleStrategy(ConfigurationPropertySource propertySource) {
        return new ElasticsearchIndexLifecycleStrategy((IndexLifecycleStrategyName)((Object)LIFECYCLE_STRATEGY.get(propertySource)), new ElasticsearchIndexLifecycleExecutionOptions((IndexStatus)((Object)LIFECYCLE_MINIMAL_REQUIRED_STATUS.get(propertySource)), (Integer)LIFECYCLE_MINIMAL_REQUIRED_STATUS_WAIT_TIMEOUT.get(propertySource)));
    }
}

