/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.orchestration.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.AbstractElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestratorImplementor;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.engine.backend.orchestration.spi.BatchingExecutor;
import org.hibernate.search.engine.common.spi.ErrorHandler;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchBatchingWorkOrchestrator
extends AbstractElasticsearchWorkOrchestrator
implements ElasticsearchWorkOrchestratorImplementor,
AutoCloseable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BatchingExecutor<AbstractElasticsearchWorkOrchestrator.ElasticsearchWorkSet, ElasticsearchWorkProcessor> executor;

    public ElasticsearchBatchingWorkOrchestrator(String name, ElasticsearchWorkProcessor processor, int maxWorksetsPerBatch, boolean fair, ErrorHandler errorHandler) {
        super(name);
        this.executor = new BatchingExecutor(name, (BatchingExecutor.WorkProcessor)processor, maxWorksetsPerBatch, fair, errorHandler);
    }

    @Override
    public void start() {
        this.executor.start();
    }

    public ElasticsearchWorkOrchestratorImplementor createChild(String name) {
        return new ElasticsearchChildBatchingWorkOrchestrator(name);
    }

    protected void doSubmit(AbstractElasticsearchWorkOrchestrator.ElasticsearchWorkSet workSet) throws InterruptedException {
        this.executor.submit((BatchingExecutor.WorkSet)workSet);
    }

    protected void doClose() {
        try (Closer closer = new Closer();){
            closer.push(ElasticsearchBatchingWorkOrchestrator::awaitCompletionBeforeClose, (Object)this);
            closer.push(BatchingExecutor::stop, this.executor);
        }
    }

    private void awaitCompletionBeforeClose() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            log.interruptedWhileWaitingForIndexActivity(this.getName(), e);
            Thread.currentThread().interrupt();
        }
    }

    private class ElasticsearchChildBatchingWorkOrchestrator
    extends AbstractElasticsearchWorkOrchestrator
    implements ElasticsearchWorkOrchestratorImplementor {
        protected ElasticsearchChildBatchingWorkOrchestrator(String name) {
            super(name);
        }

        @Override
        public void start() {
        }

        protected void doSubmit(AbstractElasticsearchWorkOrchestrator.ElasticsearchWorkSet workSet) {
            ElasticsearchBatchingWorkOrchestrator.this.submit(workSet);
        }

        protected void doClose() {
            ElasticsearchBatchingWorkOrchestrator.this.awaitCompletionBeforeClose();
        }
    }
}

