/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilder;

public abstract class AbstractElasticsearchBucketAggregation<K, V>
implements ElasticsearchSearchAggregation<Map<K, V>> {
    private final Set<String> indexNames;

    AbstractElasticsearchBucketAggregation(AbstractBuilder<K, V> builder) {
        this.indexNames = builder.searchContext.getHibernateSearchIndexNames();
    }

    @Override
    public JsonObject request(AggregationRequestContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        this.doRequest(context, outerObject, innerObject);
        return outerObject;
    }

    @Override
    public Map<K, V> extract(JsonObject aggregationResult, AggregationExtractContext context) {
        JsonElement buckets = aggregationResult.get("buckets");
        return this.doExtract(context, aggregationResult, buckets);
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    protected abstract void doRequest(AggregationRequestContext var1, JsonObject var2, JsonObject var3);

    protected abstract Map<K, V> doExtract(AggregationExtractContext var1, JsonObject var2, JsonElement var3);

    public static abstract class AbstractBuilder<K, V>
    implements SearchAggregationBuilder<Map<K, V>> {
        protected final ElasticsearchSearchContext searchContext;

        public AbstractBuilder(ElasticsearchSearchContext searchContext) {
            this.searchContext = searchContext;
        }

        public abstract ElasticsearchSearchAggregation<Map<K, V>> build();
    }
}

