/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchBucketAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchRangeAggregation<F, K>
extends AbstractElasticsearchBucketAggregation<Range<K>, Long> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String absoluteFieldPath;
    private final List<Range<K>> rangesInOrder;
    private final JsonArray rangesJson;

    private ElasticsearchRangeAggregation(Builder<F, K> builder) {
        super(builder);
        this.absoluteFieldPath = ((Builder)builder).absoluteFieldPath;
        this.rangesInOrder = ((Builder)builder).rangesInOrder;
        this.rangesJson = ((Builder)builder).rangesJson;
    }

    @Override
    protected void doRequest(AggregationRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        outerObject.add("range", (JsonElement)innerObject);
        innerObject.addProperty("field", this.absoluteFieldPath);
        innerObject.addProperty("keyed", Boolean.valueOf(true));
        innerObject.add("ranges", (JsonElement)this.rangesJson);
    }

    @Override
    protected Map<Range<K>, Long> doExtract(AggregationExtractContext context, JsonObject outerObject, JsonElement buckets) {
        JsonObject bucketMap = buckets.getAsJsonObject();
        LinkedHashMap result = CollectionHelper.newLinkedHashMap((int)this.rangesJson.size());
        for (int i = 0; i < this.rangesJson.size(); ++i) {
            JsonObject bucket = bucketMap.get(String.valueOf(i)).getAsJsonObject();
            Range<K> range = this.rangesInOrder.get(i);
            long documentCount = bucket.get("doc_count").getAsLong();
            result.put(range, documentCount);
        }
        return result;
    }

    public static class Builder<F, K>
    extends AbstractElasticsearchBucketAggregation.AbstractBuilder<Range<K>, Long>
    implements RangeAggregationBuilder<K> {
        private final String absoluteFieldPath;
        private final ToDocumentFieldValueConverter<?, ? extends F> toFieldValueConverter;
        private final ElasticsearchFieldCodec<F> codec;
        private final List<Range<K>> rangesInOrder = new ArrayList<Range<K>>();
        private final JsonArray rangesJson = new JsonArray();

        public Builder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends F> toFieldValueConverter, ElasticsearchFieldCodec<F> codec) {
            super(searchContext);
            this.absoluteFieldPath = absoluteFieldPath;
            this.toFieldValueConverter = toFieldValueConverter;
            this.codec = codec;
        }

        public void range(Range<? extends K> range) {
            Optional upperBoundValue;
            JsonObject rangeJson = new JsonObject();
            Optional lowerBoundValue = range.getLowerBoundValue();
            if (lowerBoundValue.isPresent()) {
                if (!RangeBoundInclusion.INCLUDED.equals((Object)range.getLowerBoundInclusion())) {
                    throw log.elasticsearchRangeAggregationRequiresCanonicalFormForRanges(range);
                }
                rangeJson.add("from", this.convertToFieldValue(lowerBoundValue.get()));
            }
            if ((upperBoundValue = range.getUpperBoundValue()).isPresent()) {
                if (!RangeBoundInclusion.EXCLUDED.equals((Object)range.getUpperBoundInclusion())) {
                    throw log.elasticsearchRangeAggregationRequiresCanonicalFormForRanges(range);
                }
                rangeJson.add("to", this.convertToFieldValue(upperBoundValue.get()));
            }
            rangeJson.addProperty("key", String.valueOf(this.rangesJson.size()));
            this.rangesInOrder.add(range.map(Function.identity()));
            this.rangesJson.add((JsonElement)rangeJson);
        }

        @Override
        public ElasticsearchRangeAggregation<F, K> build() {
            return new ElasticsearchRangeAggregation(this);
        }

        private JsonElement convertToFieldValue(K value) {
            try {
                Object converted = this.toFieldValueConverter.convertUnknown(value, this.searchContext.getToDocumentFieldValueConvertContext());
                return this.codec.encode(converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
            }
        }
    }
}

