/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonArrayAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.search.projection.util.impl.SloppyMath;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

class ElasticsearchDistanceToFieldProjection
implements ElasticsearchSearchProjection<Double, Double> {
    private static final JsonObjectAccessor SCRIPT_FIELDS_ACCESSOR = JsonAccessor.root().property("script_fields").asObject();
    private static final JsonObjectAccessor FIELDS_ACCESSOR = JsonAccessor.root().property("fields").asObject();
    private static final JsonArrayAccessor SCORE_ACCESSOR = JsonAccessor.root().property("sort").asArray();
    private static final Pattern NON_DIGITS_PATTERN = Pattern.compile("\\D");
    private static final String DISTANCE_PROJECTION_SCRIPT = " Object result; if (doc[params.fieldPath].size() != 0) { result = doc[params.fieldPath].arcDistance(params.lat, params.lon); } else { String nestedPath = params.nestedPath; String relativeFieldPath = params.relativeFieldPath; if (params['_source'][nestedPath] == null) return result; if (params['_source'][nestedPath][relativeFieldPath] == null) return result; return params['_source'][nestedPath][relativeFieldPath] } return result;";
    private final Set<String> indexNames;
    private final String absoluteFieldPath;
    private final String nestedPath;
    private final GeoPoint center;
    private final DistanceUnit unit;
    private final String scriptFieldName;

    ElasticsearchDistanceToFieldProjection(Set<String> indexNames, String absoluteFieldPath, String nestedPath, GeoPoint center, DistanceUnit unit) {
        this.indexNames = indexNames;
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedPath = nestedPath;
        this.center = center;
        this.unit = unit;
        this.scriptFieldName = ElasticsearchDistanceToFieldProjection.createScriptFieldName(absoluteFieldPath, center, unit);
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        if (context.getDistanceSortIndex(this.absoluteFieldPath, this.center) == null) {
            SCRIPT_FIELDS_ACCESSOR.property(this.scriptFieldName).asObject().property("script").asObject().set(requestBody, ElasticsearchDistanceToFieldProjection.createScript(this.absoluteFieldPath, this.nestedPath, this.center));
        }
    }

    @Override
    public Double extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        Optional scoreDistanceElement;
        Integer distanceSortIndex = context.getDistanceSortIndex(this.absoluteFieldPath, this.center);
        Optional<Object> distance = distanceSortIndex == null ? this.extractDistance(hit) : (!(scoreDistanceElement = SCORE_ACCESSOR.element(distanceSortIndex).get(hit)).isPresent() ? Optional.empty() : (!((JsonElement)scoreDistanceElement.get()).getAsJsonPrimitive().isNumber() ? Optional.empty() : Optional.of(((JsonElement)scoreDistanceElement.get()).getAsJsonPrimitive().getAsDouble())));
        return distance.isPresent() && Double.isFinite(distance.get()) ? this.unit.fromMeters(distance.get()) : null;
    }

    public Optional<Double> extractDistance(JsonObject hit) {
        Optional projectedFieldElement = FIELDS_ACCESSOR.property(this.scriptFieldName).asArray().element(0).get(hit);
        if (!projectedFieldElement.isPresent() || ((JsonElement)projectedFieldElement.get()).isJsonNull()) {
            return Optional.empty();
        }
        if (((JsonElement)projectedFieldElement.get()).isJsonPrimitive()) {
            return Optional.of(((JsonElement)projectedFieldElement.get()).getAsDouble());
        }
        JsonObject geoPoint = ((JsonElement)projectedFieldElement.get()).getAsJsonObject();
        double distanceInMeters = SloppyMath.haversinMeters(this.center.getLatitude(), this.center.getLongitude(), geoPoint.get("lat").getAsDouble(), geoPoint.get("lon").getAsDouble());
        return Optional.of(this.unit.fromMeters(Double.valueOf(distanceInMeters)));
    }

    @Override
    public Double transform(LoadingResult<?> loadingResult, Double extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("absoluteFieldPath=").append(this.absoluteFieldPath).append(", center=").append(this.center).append(", unit=").append(this.unit).append("]");
        return sb.toString();
    }

    private static String createScriptFieldName(String absoluteFieldPath, GeoPoint center, DistanceUnit unit) {
        StringBuilder sb = new StringBuilder();
        sb.append("distance_").append(absoluteFieldPath).append("_").append(NON_DIGITS_PATTERN.matcher(Double.toString(center.getLatitude())).replaceAll("_")).append("_").append(NON_DIGITS_PATTERN.matcher(Double.toString(center.getLongitude())).replaceAll("_")).append("_").append(unit.name());
        return sb.toString();
    }

    private static JsonObject createScript(String absoluteFieldPath, String nestedPath, GeoPoint center) {
        String relativeFieldPath = nestedPath != null && absoluteFieldPath.startsWith(nestedPath) ? absoluteFieldPath.substring(nestedPath.length() + 1) : null;
        JsonObject params = new JsonObject();
        params.addProperty("lat", (Number)center.getLatitude());
        params.addProperty("lon", (Number)center.getLongitude());
        params.addProperty("fieldPath", absoluteFieldPath);
        params.addProperty("nestedPath", nestedPath);
        params.addProperty("relativeFieldPath", relativeFieldPath);
        JsonObject scriptContent = new JsonObject();
        scriptContent.addProperty("lang", "painless");
        scriptContent.add("params", (JsonElement)params);
        scriptContent.addProperty("source", DISTANCE_PROJECTION_SCRIPT);
        return scriptContent;
    }
}

