/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractorHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchDocumentReferenceProjection
implements ElasticsearchSearchProjection<DocumentReference, DocumentReference> {
    private final Set<String> indexNames;
    private final DocumentReferenceExtractorHelper helper;

    ElasticsearchDocumentReferenceProjection(Set<String> indexNames, DocumentReferenceExtractorHelper helper) {
        this.indexNames = indexNames;
        this.helper = helper;
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        this.helper.requestDocumentReference(requestBody);
    }

    @Override
    public DocumentReference extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return this.helper.extractDocumentReference(hit);
    }

    @Override
    public DocumentReference transform(LoadingResult<?> loadingResult, DocumentReference extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }
}

