/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;

class ElasticsearchScoreProjection
implements ElasticsearchSearchProjection<Float, Float> {
    private static final JsonAccessor<Boolean> TRACK_SCORES_ACCESSOR = JsonAccessor.root().property("track_scores").asBoolean();
    private final Set<String> indexNames;

    ElasticsearchScoreProjection(Set<String> indexNames) {
        this.indexNames = indexNames;
    }

    @Override
    public void request(JsonObject requestBody, SearchProjectionRequestContext context) {
        TRACK_SCORES_ACCESSOR.set(requestBody, true);
    }

    @Override
    public Float extract(ProjectionHitMapper<?, ?> projectionHitMapper, JsonObject responseBody, JsonObject hit, SearchProjectionExtractContext context) {
        return Float.valueOf(hit.get("_score").getAsFloat());
    }

    @Override
    public Float transform(LoadingResult<?> loadingResult, Float extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

