/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchQueryElementCollector;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeListProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryBuilder;
import org.hibernate.search.backend.elasticsearch.search.query.impl.SearchBackendContext;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilderFactory;

public class ElasticsearchSearchQueryBuilderFactory
implements SearchQueryBuilderFactory<ElasticsearchSearchQueryElementCollector> {
    private final SearchBackendContext searchBackendContext;
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory;

    public ElasticsearchSearchQueryBuilderFactory(SearchBackendContext searchBackendContext, ElasticsearchSearchContext searchContext, ElasticsearchSearchProjectionBuilderFactory searchProjectionFactory) {
        this.searchBackendContext = searchBackendContext;
        this.searchContext = searchContext;
        this.searchProjectionFactory = searchProjectionFactory;
    }

    public <E> ElasticsearchSearchQueryBuilder<E> asEntity(BackendSessionContext sessionContext, LoadingContextBuilder<?, E> loadingContextBuilder) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, new ElasticsearchEntityProjection(this.searchContext.getHibernateSearchIndexNames(), this.searchBackendContext.getDocumentReferenceExtractorHelper()));
    }

    public <R> ElasticsearchSearchQueryBuilder<R> asReference(BackendSessionContext sessionContext, LoadingContextBuilder<R, ?> loadingContextBuilder) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, new ElasticsearchEntityReferenceProjection(this.searchContext.getHibernateSearchIndexNames(), this.searchBackendContext.getDocumentReferenceExtractorHelper()));
    }

    public <P> ElasticsearchSearchQueryBuilder<P> asProjection(BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, SearchProjection<P> projection) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, this.searchProjectionFactory.toImplementation(projection));
    }

    public ElasticsearchSearchQueryBuilder<List<?>> asProjections(BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, SearchProjection<?> ... projections) {
        return this.createSearchQueryBuilder(sessionContext, loadingContextBuilder, this.createRootProjection(projections));
    }

    private ElasticsearchSearchProjection<?, List<?>> createRootProjection(SearchProjection<?>[] projections) {
        ArrayList children = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            children.add(this.searchProjectionFactory.toImplementation(projection));
        }
        return new ElasticsearchCompositeListProjection(this.searchContext.getHibernateSearchIndexNames(), Function.identity(), children);
    }

    private <H> ElasticsearchSearchQueryBuilder<H> createSearchQueryBuilder(BackendSessionContext sessionContext, LoadingContextBuilder<?, ?> loadingContextBuilder, ElasticsearchSearchProjection<?, H> rootProjection) {
        return this.searchBackendContext.createSearchQueryBuilder(this.searchContext, sessionContext, loadingContextBuilder, rootProjection);
    }
}

