/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.aggregation.impl;

import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.aggregation.spi.RangeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchGeoPointFieldAggregationBuilderFactory
implements ElasticsearchFieldAggregationBuilderFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final boolean aggregable;
    private final ToDocumentFieldValueConverter<?, ? extends GeoPoint> toFieldValueConverter;
    private final FromDocumentFieldValueConverter<? super GeoPoint, ?> fromFieldValueConverter;
    private final ElasticsearchFieldCodec<GeoPoint> codec;

    public ElasticsearchGeoPointFieldAggregationBuilderFactory(boolean aggregable, ToDocumentFieldValueConverter<?, ? extends GeoPoint> toFieldValueConverter, FromDocumentFieldValueConverter<? super GeoPoint, ?> fromFieldValueConverter, ElasticsearchFieldCodec<GeoPoint> codec) {
        this.aggregable = aggregable;
        this.toFieldValueConverter = toFieldValueConverter;
        this.fromFieldValueConverter = fromFieldValueConverter;
        this.codec = codec;
    }

    @Override
    public <K> TermsAggregationBuilder<K> createTermsAggregationBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        throw log.directValueLookupNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public <K> RangeAggregationBuilder<K> createRangeAggregationBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, Class<K> expectedType, ValueConvert convert) {
        throw log.rangesNotSupportedByGeoPoint(EventContexts.fromIndexFieldAbsolutePath((String)absoluteFieldPath));
    }

    @Override
    public boolean hasCompatibleCodec(ElasticsearchFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchGeoPointFieldAggregationBuilderFactory castedOther = (ElasticsearchGeoPointFieldAggregationBuilderFactory)other;
        return this.aggregable == castedOther.aggregable && this.codec.isCompatibleWith(castedOther.codec);
    }

    @Override
    public boolean hasCompatibleConverter(ElasticsearchFieldAggregationBuilderFactory other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        ElasticsearchGeoPointFieldAggregationBuilderFactory castedOther = (ElasticsearchGeoPointFieldAggregationBuilderFactory)other;
        return this.toFieldValueConverter.isCompatibleWith(castedOther.toFieldValueConverter) && this.fromFieldValueConverter.isCompatibleWith(castedOther.fromFieldValueConverter);
    }
}

