/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughFromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.PassThroughToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeConverterStep;
import org.hibernate.search.util.common.impl.Contracts;

abstract class AbstractElasticsearchIndexFieldTypeConverterStep<S extends AbstractElasticsearchIndexFieldTypeConverterStep<?, F>, F>
implements IndexFieldTypeConverterStep<S, F> {
    private final ElasticsearchIndexFieldTypeBuildContext buildContext;
    private final Class<F> fieldType;
    private ToDocumentFieldValueConverter<?, ? extends F> dslToIndexConverter;
    private FromDocumentFieldValueConverter<? super F, ?> indexToProjectionConverter;

    AbstractElasticsearchIndexFieldTypeConverterStep(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType) {
        this.buildContext = buildContext;
        this.fieldType = fieldType;
    }

    public S dslConverter(ToDocumentFieldValueConverter<?, ? extends F> toIndexConverter) {
        Contracts.assertNotNull(toIndexConverter, (String)"toIndexConverter");
        this.dslToIndexConverter = toIndexConverter;
        return this.thisAsS();
    }

    public S projectionConverter(FromDocumentFieldValueConverter<? super F, ?> fromIndexConverter) {
        Contracts.assertNotNull(fromIndexConverter, (String)"fromIndexConverter");
        this.indexToProjectionConverter = fromIndexConverter;
        return this.thisAsS();
    }

    protected abstract S thisAsS();

    final Class<F> getFieldType() {
        return this.fieldType;
    }

    final ElasticsearchIndexFieldTypeBuildContext getBuildContext() {
        return this.buildContext;
    }

    final ToDocumentFieldValueConverter<?, ? extends F> createDslToIndexConverter() {
        return this.dslToIndexConverter == null ? this.createToDocumentRawConverter() : this.dslToIndexConverter;
    }

    final ToDocumentFieldValueConverter<F, ? extends F> createToDocumentRawConverter() {
        return new PassThroughToDocumentFieldValueConverter(this.fieldType);
    }

    final FromDocumentFieldValueConverter<? super F, ?> createIndexToProjectionConverter() {
        return this.indexToProjectionConverter == null ? this.createFromDocumentRawConverter() : this.indexToProjectionConverter;
    }

    final FromDocumentFieldValueConverter<? super F, F> createFromDocumentRawConverter() {
        return new PassThroughFromDocumentFieldValueConverter(this.fieldType);
    }
}

