/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import com.google.gson.Gson;
import org.hibernate.search.backend.elasticsearch.document.model.esnative.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.types.aggregation.impl.ElasticsearchStandardFieldAggregationBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchJsonStringFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.ElasticsearchNativeIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchIndexFieldTypeConverterStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexFieldType;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardFieldPredicateBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.projection.impl.ElasticsearchStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.elasticsearch.types.sort.impl.ElasticsearchStandardFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.FromDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;

class ElasticsearchNativeIndexFieldTypeOptionsStepImpl
extends AbstractElasticsearchIndexFieldTypeConverterStep<ElasticsearchNativeIndexFieldTypeOptionsStepImpl, String>
implements ElasticsearchNativeIndexFieldTypeOptionsStep<ElasticsearchNativeIndexFieldTypeOptionsStepImpl> {
    private final String mappingJsonString;

    ElasticsearchNativeIndexFieldTypeOptionsStepImpl(ElasticsearchIndexFieldTypeBuildContext buildContext, String mappingJsonString) {
        super(buildContext, String.class);
        this.mappingJsonString = mappingJsonString;
    }

    @Override
    protected ElasticsearchNativeIndexFieldTypeOptionsStepImpl thisAsS() {
        return this;
    }

    public IndexFieldType<String> toIndexFieldType() {
        Gson gson = this.getBuildContext().getUserFacingGson();
        PropertyMapping mapping = (PropertyMapping)gson.fromJson(this.mappingJsonString, PropertyMapping.class);
        ToDocumentFieldValueConverter dslToIndexConverter = this.createDslToIndexConverter();
        ToDocumentFieldValueConverter rawDslToIndexConverter = this.createToDocumentRawConverter();
        FromDocumentFieldValueConverter indexToProjectionConverter = this.createIndexToProjectionConverter();
        FromDocumentFieldValueConverter rawIndexToProjectionConverter = this.createFromDocumentRawConverter();
        ElasticsearchJsonStringFieldCodec codec = new ElasticsearchJsonStringFieldCodec(gson);
        return new ElasticsearchIndexFieldType<String>(codec, new ElasticsearchStandardFieldPredicateBuilderFactory<String>(true, dslToIndexConverter, this.createToDocumentRawConverter(), codec), new ElasticsearchStandardFieldSortBuilderFactory<String>(true, dslToIndexConverter, this.createToDocumentRawConverter(), codec), new ElasticsearchStandardFieldProjectionBuilderFactory<String>(true, indexToProjectionConverter, this.createFromDocumentRawConverter(), codec), new ElasticsearchStandardFieldAggregationBuilderFactory<String>(true, dslToIndexConverter, rawDslToIndexConverter, indexToProjectionConverter, rawIndexToProjectionConverter, codec), mapping);
    }
}

