/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.scope.model.impl.ElasticsearchCompatibilityChecker;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicateContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.predicate.impl.ElasticsearchStandardMatchPredicateBuilder;
import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchTextMatchPredicateBuilder
extends ElasticsearchStandardMatchPredicateBuilder<String> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonAccessor<Integer> FUZZINESS_ACCESSOR = JsonAccessor.root().property("fuzziness").asInteger();
    private static final JsonAccessor<Integer> PREFIX_LENGTH_ACCESSOR = JsonAccessor.root().property("prefix_length").asInteger();
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private final String type;
    private final ElasticsearchCompatibilityChecker analyzerChecker;
    private Integer fuzziness;
    private Integer prefixLength;
    private String analyzer;

    ElasticsearchTextMatchPredicateBuilder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, ToDocumentFieldValueConverter<?, ? extends String> converter, ToDocumentFieldValueConverter<String, ? extends String> rawConverter, ElasticsearchCompatibilityChecker converterChecker, ElasticsearchFieldCodec<String> codec, String type, ElasticsearchCompatibilityChecker analyzerChecker) {
        super(searchContext, absoluteFieldPath, converter, rawConverter, converterChecker, codec);
        this.type = type;
        this.analyzerChecker = analyzerChecker;
    }

    @Override
    public void fuzzy(int maxEditDistance, int exactPrefixLength) {
        this.fuzziness = maxEditDistance;
        this.prefixLength = exactPrefixLength;
    }

    @Override
    public void analyzer(String analyzerName) {
        this.analyzer = analyzerName;
    }

    @Override
    public void skipAnalysis() {
        if ("keyword".equals(this.type)) {
            throw log.skipAnalysisOnKeywordField(this.absoluteFieldPath, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
        }
        this.analyzer("keyword");
    }

    @Override
    protected JsonObject doBuild(ElasticsearchSearchPredicateContext context, JsonObject outerObject, JsonObject innerObject) {
        if (this.analyzer == null) {
            this.analyzerChecker.failIfNotCompatible();
        }
        if (this.fuzziness != null) {
            FUZZINESS_ACCESSOR.set(innerObject, this.fuzziness);
        }
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        if (this.prefixLength != null) {
            PREFIX_LENGTH_ACCESSOR.set(innerObject, this.prefixLength);
        }
        return super.doBuild(context, outerObject, innerObject);
    }
}

