/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchDocumentObjectBuilder;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.DeleteWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.IndexWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlan;

public class ElasticsearchIndexIndexingPlan
implements IndexIndexingPlan<ElasticsearchDocumentObjectBuilder> {
    private final ElasticsearchWorkBuilderFactory builderFactory;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final ElasticsearchWorkOrchestrator orchestrator;
    private final URLEncodedString indexName;
    private final DocumentRefreshStrategy refreshStrategy;
    private final String tenantId;
    private final List<ElasticsearchWork<?>> works = new ArrayList();

    public ElasticsearchIndexIndexingPlan(ElasticsearchWorkBuilderFactory builderFactory, MultiTenancyStrategy multiTenancyStrategy, ElasticsearchWorkOrchestrator orchestrator, URLEncodedString indexName, DocumentRefreshStrategy refreshStrategy, BackendSessionContext sessionContext) {
        this.builderFactory = builderFactory;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.orchestrator = orchestrator;
        this.indexName = indexName;
        this.refreshStrategy = refreshStrategy;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public void add(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void update(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        this.index(referenceProvider, documentContributor);
    }

    public void delete(DocumentReferenceProvider referenceProvider) {
        String elasticsearchId = this.multiTenancyStrategy.toElasticsearchId(this.tenantId, referenceProvider.getIdentifier());
        String routingKey = referenceProvider.getRoutingKey();
        this.collect((ElasticsearchWork<?>)((DeleteWorkBuilder)this.builderFactory.delete(this.indexName, URLEncodedString.fromString(elasticsearchId), routingKey).refresh(this.refreshStrategy)).build());
    }

    public void process() {
    }

    public CompletableFuture<?> execute() {
        try {
            CompletableFuture<?> completableFuture = this.orchestrator.submit(this.works);
            return completableFuture;
        }
        finally {
            this.works.clear();
        }
    }

    public void discard() {
        this.works.clear();
    }

    private void index(DocumentReferenceProvider referenceProvider, DocumentContributor<ElasticsearchDocumentObjectBuilder> documentContributor) {
        String id = referenceProvider.getIdentifier();
        String elasticsearchId = this.multiTenancyStrategy.toElasticsearchId(this.tenantId, id);
        String routingKey = referenceProvider.getRoutingKey();
        ElasticsearchDocumentObjectBuilder builder = new ElasticsearchDocumentObjectBuilder();
        documentContributor.contribute((Object)builder);
        JsonObject document = builder.build(this.multiTenancyStrategy, this.tenantId, id);
        this.collect((ElasticsearchWork<?>)((IndexWorkBuilder)this.builderFactory.index(this.indexName, URLEncodedString.fromString(elasticsearchId), routingKey, document).refresh(this.refreshStrategy)).build());
    }

    private void collect(ElasticsearchWork<?> work) {
        this.works.add(work);
    }
}

