/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.SearchWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractSimpleElasticsearchWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.DefaultLogCategories;
import org.hibernate.search.util.common.logging.impl.LogCategory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchWork<R>
extends AbstractSimpleElasticsearchWork<R> {
    private static final Log QUERY_LOG = (Log)LoggerFactory.make(Log.class, (LogCategory)DefaultLogCategories.QUERY);
    private final ElasticsearchSearchResultExtractor<R> resultExtractor;

    protected SearchWork(Builder<R> builder) {
        super(builder);
        this.resultExtractor = ((Builder)builder).resultExtractor;
    }

    @Override
    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        QUERY_LOG.executingElasticsearchQuery(request.getPath(), request.getParameters(), executionContext.getGsonProvider().getLogHelper().toString(request.getBodyParts()));
        return super.beforeExecute(executionContext, request);
    }

    @Override
    protected R generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.getBody();
        return this.resultExtractor.extract(body);
    }

    public static class Builder<R>
    extends AbstractSimpleElasticsearchWork.AbstractBuilder<Builder<R>>
    implements SearchWorkBuilder<R> {
        private final JsonObject payload;
        private final ElasticsearchSearchResultExtractor<R> resultExtractor;
        private final Boolean trackTotalHits;
        private final Set<URLEncodedString> indexes = new HashSet<URLEncodedString>();
        private Integer from;
        private Integer size;
        private Integer scrollSize;
        private String scrollTimeout;
        private Set<String> routingKeys;

        public static <T> Builder<T> forElasticsearch6AndBelow(JsonObject payload, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            return new Builder<T>(payload, resultExtractor, null);
        }

        public static <T> Builder<T> forElasticsearch7AndAbove(JsonObject payload, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            return new Builder<T>(payload, resultExtractor, true);
        }

        private Builder(JsonObject payload, ElasticsearchSearchResultExtractor<R> resultExtractor, Boolean trackTotalHits) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.payload = payload;
            this.resultExtractor = resultExtractor;
            this.trackTotalHits = trackTotalHits;
        }

        @Override
        public Builder<R> indexes(Collection<URLEncodedString> indexNames) {
            this.indexes.addAll(indexNames);
            return this;
        }

        @Override
        public Builder<R> paging(Integer limit, Integer offset) {
            this.from = offset;
            this.size = limit;
            return this;
        }

        @Override
        public Builder<R> scrolling(int scrollSize, String scrollTimeout) {
            this.scrollSize = scrollSize;
            this.scrollTimeout = scrollTimeout;
            return this;
        }

        @Override
        public SearchWorkBuilder<R> routingKeys(Set<String> routingKeys) {
            this.routingKeys = routingKeys;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().multiValuedPathComponent(this.indexes).pathComponent(Paths._SEARCH).body(this.payload);
            if (this.from != null) {
                builder.param("from", this.from);
            }
            if (this.size != null) {
                builder.param("size", this.size);
            }
            if (this.scrollSize != null && this.scrollTimeout != null) {
                builder.param("size", this.scrollSize);
                builder.param("scroll", this.scrollTimeout);
            }
            if (!this.routingKeys.isEmpty()) {
                builder.multiValuedParam("routing", this.routingKeys);
            }
            if (this.trackTotalHits != null) {
                builder.param("track_total_hits", this.trackTotalHits);
            }
            return builder.build();
        }

        @Override
        public SearchWork<R> build() {
            return new SearchWork(this);
        }
    }
}

