/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.impl.ElasticsearchIndexObjectFieldReference;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.AbstractElasticsearchIndexSchemaObjectNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicType;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchIndexSchemaObjectFieldNodeBuilder
extends AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectFieldNodeBuilder,
ElasticsearchIndexSchemaNodeContributor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final AbstractElasticsearchIndexSchemaObjectNodeBuilder parent;
    private final String absoluteFieldPath;
    private final String relativeFieldName;
    private final IndexFieldInclusion inclusion;
    private final ObjectStructure structure;
    private boolean multiValued = false;
    private ElasticsearchIndexObjectFieldReference reference;

    ElasticsearchIndexSchemaObjectFieldNodeBuilder(AbstractElasticsearchIndexSchemaObjectNodeBuilder parent, String relativeFieldName, IndexFieldInclusion inclusion, ObjectStructure structure) {
        this.parent = parent;
        String parentAbsolutePath = parent.getAbsolutePath();
        this.absoluteFieldPath = parentAbsolutePath == null ? relativeFieldName : FieldPaths.compose((String)parentAbsolutePath, (String)relativeFieldName);
        this.relativeFieldName = relativeFieldName;
        this.inclusion = inclusion;
        this.structure = structure;
    }

    public EventContext eventContext() {
        return this.getRootNodeBuilder().getIndexEventContext().append(EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
    }

    public void multiValued() {
        this.multiValued = true;
    }

    public IndexObjectFieldReference toReference() {
        if (this.reference != null) {
            throw log.cannotCreateReferenceMultipleTimes(this.eventContext());
        }
        this.reference = new ElasticsearchIndexObjectFieldReference();
        return this.reference;
    }

    @Override
    public void contribute(ElasticsearchIndexSchemaNodeCollector collector, ElasticsearchIndexSchemaObjectNode parentNode, List<AbstractElasticsearchIndexSchemaFieldNode> staticChildrenForParent, AbstractTypeMapping parentMapping) {
        if (this.reference == null) {
            throw log.incompleteFieldDefinition(this.eventContext());
        }
        ArrayList<AbstractElasticsearchIndexSchemaFieldNode> staticChildren = new ArrayList<AbstractElasticsearchIndexSchemaFieldNode>();
        ElasticsearchIndexSchemaObjectFieldNode fieldNode = new ElasticsearchIndexSchemaObjectFieldNode(parentNode, this.relativeFieldName, this.inclusion, this.structure, this.multiValued, staticChildren);
        staticChildrenForParent.add(fieldNode);
        collector.collect(this.absoluteFieldPath, fieldNode);
        this.reference.setSchemaNode(fieldNode);
        DynamicType dynamicType = parentMapping.getDynamic();
        if (DynamicType.STRICT.equals((Object)dynamicType)) {
            dynamicType = this.resolveSelfDynamicType();
        }
        PropertyMapping mapping = ElasticsearchIndexSchemaObjectFieldNodeBuilder.createPropertyMapping(this.structure, dynamicType);
        if (IndexFieldInclusion.INCLUDED.equals((Object)fieldNode.inclusion())) {
            parentMapping.addProperty(this.relativeFieldName, mapping);
        }
        this.contributeChildren(mapping, fieldNode, collector, staticChildren);
    }

    @Override
    ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder() {
        return this.parent.getRootNodeBuilder();
    }

    @Override
    String getAbsolutePath() {
        return this.absoluteFieldPath;
    }

    static PropertyMapping createPropertyMapping(ObjectStructure structure, DynamicType dynamicType) {
        PropertyMapping mapping = new PropertyMapping();
        String dataType = "object";
        switch (structure) {
            case DEFAULT: {
                break;
            }
            case FLATTENED: {
                dataType = "object";
                break;
            }
            case NESTED: {
                dataType = "nested";
            }
        }
        mapping.setType(dataType);
        mapping.setDynamic(dynamicType);
        return mapping;
    }
}

