/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.List;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.impl.SearchQueryElementTypeKey;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldDescriptor;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexSchemaValueFieldNode<F>
extends AbstractElasticsearchIndexSchemaFieldNode
implements IndexValueFieldDescriptor,
ElasticsearchSearchValueFieldContext<F> {
    private final List<String> nestedPathHierarchy;
    private final ElasticsearchIndexValueFieldType<F> type;

    public ElasticsearchIndexSchemaValueFieldNode(ElasticsearchIndexSchemaObjectNode parent, String relativeFieldName, IndexFieldInclusion inclusion, boolean multiValued, ElasticsearchIndexValueFieldType<F> type) {
        super(parent, relativeFieldName, inclusion, multiValued);
        this.nestedPathHierarchy = parent.nestedPathHierarchy();
        this.type = type;
    }

    public boolean isObjectField() {
        return false;
    }

    public boolean isValueField() {
        return true;
    }

    @Override
    public ElasticsearchIndexSchemaObjectFieldNode toObjectField() {
        throw log.invalidIndexElementTypeValueFieldIsNotObjectField(this.absolutePath);
    }

    @Override
    public ElasticsearchIndexSchemaValueFieldNode<F> toValueField() {
        return this;
    }

    @Override
    public List<String> nestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    @Override
    public ElasticsearchIndexValueFieldType<F> type() {
        return this.type;
    }

    public EventContext eventContext() {
        return EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath);
    }

    @Override
    public <T> T queryElement(SearchQueryElementTypeKey<T> key, ElasticsearchSearchContext searchContext) {
        ElasticsearchSearchFieldQueryElementFactory factory = this.type().queryElementFactory(key);
        if (factory == null) {
            throw log.cannotUseQueryElementForField(this.absolutePath(), key.toString(), this.eventContext());
        }
        return factory.create(searchContext, this);
    }

    public <T> ElasticsearchIndexSchemaValueFieldNode<? super T> withValueType(Class<T> expectedSubType, EventContext eventContext) {
        if (!this.type.valueClass().isAssignableFrom(expectedSubType)) {
            throw log.invalidFieldValueType(this.type.valueClass(), expectedSubType, eventContext.append(EventContexts.fromIndexFieldAbsolutePath((String)this.absolutePath)));
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("parent=").append(this.parent).append(", type=").append(this.type).append("]");
        return sb.toString();
    }
}

