/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchBackendSettings;
import org.hibernate.search.backend.elasticsearch.cfg.spi.ElasticsearchBackendSpiSettings;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.backend.elasticsearch.dialect.model.impl.ElasticsearchModelDialect;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchBackendImpl;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchLinkImpl;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.DefaultIndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.mapping.TypeNameMappingStrategyName;
import org.hibernate.search.backend.elasticsearch.mapping.impl.DiscriminatorTypeNameMapping;
import org.hibernate.search.backend.elasticsearch.mapping.impl.IndexNameTypeNameMapping;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.multitenancy.MultiTenancyStrategyName;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.DiscriminatorMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.NoMultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryProvider;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendFactory;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchBackendFactory
implements BackendFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<ElasticsearchVersion> VERSION = ConfigurationProperty.forKey((String)"version").as(ElasticsearchVersion.class, ElasticsearchVersion::of).build();
    private static final ConfigurationProperty<Boolean> VERSION_CHECK_ENABLED = ConfigurationProperty.forKey((String)"version_check.enabled").asBoolean().withDefault((Object)true).build();
    private static final ConfigurationProperty<MultiTenancyStrategyName> MULTI_TENANCY_STRATEGY = ConfigurationProperty.forKey((String)"multi_tenancy.strategy").as(MultiTenancyStrategyName.class, MultiTenancyStrategyName::of).withDefault((Object)ElasticsearchBackendSettings.Defaults.MULTI_TENANCY_STRATEGY).build();
    private static final ConfigurationProperty<Boolean> LOG_JSON_PRETTY_PRINTING = ConfigurationProperty.forKey((String)"log.json_pretty_printing").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<BeanReference<? extends ElasticsearchClientFactory>> CLIENT_FACTORY = ConfigurationProperty.forKey((String)"client_factory").asBeanReference(ElasticsearchClientFactory.class).withDefault(ElasticsearchBackendSpiSettings.Defaults.CLIENT_FACTORY).build();
    private static final ConfigurationProperty<TypeNameMappingStrategyName> MAPPING_TYPE_STRATEGY = ConfigurationProperty.forKey((String)"mapping.type_name.strategy").as(TypeNameMappingStrategyName.class, TypeNameMappingStrategyName::of).withDefault((Object)ElasticsearchBackendSettings.Defaults.MAPPING_TYPE_NAME_STRATEGY).build();
    private static final ConfigurationProperty<BeanReference<? extends IndexLayoutStrategy>> LAYOUT_STRATEGY = ConfigurationProperty.forKey((String)"layout.strategy").asBeanReference(IndexLayoutStrategy.class).withDefault((Object)BeanReference.of(DefaultIndexLayoutStrategy.class)).build();

    public BackendImplementor create(EventContext eventContext, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        boolean logPrettyPrinting = (Boolean)LOG_JSON_PRETTY_PRINTING.get(propertySource);
        GsonProvider defaultGsonProvider = GsonProvider.create(GsonBuilder::new, logPrettyPrinting);
        Optional configuredVersion = (Optional)VERSION.get(propertySource);
        boolean versionCheckEnabled = this.getVersionCheckEnabled(propertySource);
        BeanResolver beanResolver = buildContext.beanResolver();
        BeanHolder clientFactoryHolder = null;
        BeanHolder<? extends IndexLayoutStrategy> indexLayoutStrategyHolder = null;
        BackendThreads threads = null;
        ElasticsearchLinkImpl link = null;
        try {
            ElasticsearchVersion version;
            threads = new BackendThreads(eventContext.render());
            clientFactoryHolder = (BeanHolder)CLIENT_FACTORY.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
            ElasticsearchDialectFactory dialectFactory = new ElasticsearchDialectFactory();
            link = new ElasticsearchLinkImpl((BeanHolder<? extends ElasticsearchClientFactory>)clientFactoryHolder, threads, defaultGsonProvider, logPrettyPrinting, dialectFactory, configuredVersion, versionCheckEnabled);
            if (configuredVersion.isPresent()) {
                version = (ElasticsearchVersion)configuredVersion.get();
            } else {
                threads.onStart(propertySource, buildContext.threadPoolProvider());
                link.onStart(propertySource);
                version = link.getElasticsearchVersion();
            }
            ElasticsearchModelDialect dialect = dialectFactory.createModelDialect(version);
            Gson userFacingGson = new GsonBuilder().setPrettyPrinting().create();
            ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider = dialect.createIndexTypeFieldFactoryProvider(userFacingGson);
            indexLayoutStrategyHolder = this.createIndexLayoutStrategy(buildContext, propertySource);
            return new ElasticsearchBackendImpl(eventContext, threads, link, typeFactoryProvider, userFacingGson, this.getMultiTenancyStrategy(propertySource), indexLayoutStrategyHolder, this.createTypeNameMapping(propertySource, (IndexLayoutStrategy)indexLayoutStrategyHolder.get()), buildContext.failureHandler(), buildContext.timingSource());
        }
        catch (RuntimeException e) {
            ((SuppressingCloser)((SuppressingCloser)((SuppressingCloser)new SuppressingCloser((Throwable)e).push(BeanHolder::close, clientFactoryHolder)).push(BeanHolder::close, indexLayoutStrategyHolder)).push(ElasticsearchLinkImpl::onStop, link)).push(BackendThreads::onStop, (Object)threads);
            throw e;
        }
    }

    private boolean getVersionCheckEnabled(ConfigurationPropertySource propertySource) {
        Optional configuredVersionOptional = (Optional)VERSION.get(propertySource);
        boolean versionCheckEnabled = (Boolean)VERSION_CHECK_ENABLED.get(propertySource);
        if (!versionCheckEnabled) {
            if (configuredVersionOptional.isPresent() && !((ElasticsearchVersion)configuredVersionOptional.get()).minor().isPresent()) {
                throw log.invalidElasticsearchVersionCheckConfiguration(((ElasticsearchVersion)configuredVersionOptional.get()).toString());
            }
            if (!configuredVersionOptional.isPresent()) {
                throw log.invalidElasticsearchVersionCheckConfiguration(null);
            }
        }
        return versionCheckEnabled;
    }

    private MultiTenancyStrategy getMultiTenancyStrategy(ConfigurationPropertySource propertySource) {
        MultiTenancyStrategyName multiTenancyStrategyName = (MultiTenancyStrategyName)((Object)MULTI_TENANCY_STRATEGY.get(propertySource));
        switch (multiTenancyStrategyName) {
            case NONE: {
                return new NoMultiTenancyStrategy();
            }
            case DISCRIMINATOR: {
                return new DiscriminatorMultiTenancyStrategy();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported multi-tenancy strategy '%1$s'", new Object[]{multiTenancyStrategyName}));
    }

    private BeanHolder<? extends IndexLayoutStrategy> createIndexLayoutStrategy(BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        BeanResolver beanResolver = buildContext.beanResolver();
        return (BeanHolder)LAYOUT_STRATEGY.getAndTransform(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0));
    }

    private TypeNameMapping createTypeNameMapping(ConfigurationPropertySource propertySource, IndexLayoutStrategy indexLayoutStrategy) {
        TypeNameMappingStrategyName strategyName = (TypeNameMappingStrategyName)((Object)MAPPING_TYPE_STRATEGY.get(propertySource));
        switch (strategyName) {
            case INDEX_NAME: {
                return new IndexNameTypeNameMapping(indexLayoutStrategy);
            }
            case DISCRIMINATOR: {
                return new DiscriminatorTypeNameMapping();
            }
        }
        throw new AssertionFailure(String.format(Locale.ROOT, "Unsupported type mapping strategy '%1$s'", new Object[]{strategyName}));
    }
}

