/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.Gson;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.ElasticsearchBackend;
import org.hibernate.search.backend.elasticsearch.analysis.ElasticsearchAnalysisConfigurer;
import org.hibernate.search.backend.elasticsearch.analysis.model.dsl.impl.ElasticsearchAnalysisConfigurationContextImpl;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.impl.DocumentMetadataContributor;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchLinkImpl;
import org.hibernate.search.backend.elasticsearch.impl.IndexNamesRegistry;
import org.hibernate.search.backend.elasticsearch.index.impl.ElasticsearchIndexManagerBuilder;
import org.hibernate.search.backend.elasticsearch.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.elasticsearch.index.layout.IndexLayoutStrategy;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.mapping.impl.TypeNameMapping;
import org.hibernate.search.backend.elasticsearch.multitenancy.impl.MultiTenancyStrategy;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSimpleWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.types.dsl.provider.impl.ElasticsearchIndexFieldTypeFactoryProvider;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.Backend;
import org.hibernate.search.engine.backend.index.spi.IndexManagerBuilder;
import org.hibernate.search.engine.backend.orchestration.spi.AbstractWorkOrchestrator;
import org.hibernate.search.engine.backend.spi.BackendBuildContext;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.backend.spi.BackendStartContext;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ElasticsearchBackendImpl
implements BackendImplementor,
ElasticsearchBackend {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final OptionalConfigurationProperty<BeanReference<? extends ElasticsearchAnalysisConfigurer>> ANALYSIS_CONFIGURER = ConfigurationProperty.forKey((String)"analysis.configurer").asBeanReference(ElasticsearchAnalysisConfigurer.class).build();
    private final EventContext eventContext;
    private final BackendThreads threads;
    private final ElasticsearchLinkImpl link;
    private final ElasticsearchSimpleWorkOrchestrator generalPurposeOrchestrator;
    private final ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider;
    private final MultiTenancyStrategy multiTenancyStrategy;
    private final BeanHolder<? extends IndexLayoutStrategy> indexLayoutStrategyHolder;
    private final TypeNameMapping typeNameMapping;
    private final IndexManagerBackendContext indexManagerBackendContext;
    private final IndexNamesRegistry indexNamesRegistry;

    ElasticsearchBackendImpl(EventContext eventContext, BackendThreads threads, ElasticsearchLinkImpl link, ElasticsearchIndexFieldTypeFactoryProvider typeFactoryProvider, Gson userFacingGson, MultiTenancyStrategy multiTenancyStrategy, BeanHolder<? extends IndexLayoutStrategy> indexLayoutStrategyHolder, TypeNameMapping typeNameMapping, FailureHandler failureHandler, TimingSource timingSource) {
        this.eventContext = eventContext;
        this.threads = threads;
        this.link = link;
        this.generalPurposeOrchestrator = new ElasticsearchSimpleWorkOrchestrator("Elasticsearch general purpose orchestrator - " + eventContext.render(), link);
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.typeFactoryProvider = typeFactoryProvider;
        this.indexLayoutStrategyHolder = indexLayoutStrategyHolder;
        this.typeNameMapping = typeNameMapping;
        this.indexManagerBackendContext = new IndexManagerBackendContext(this, eventContext, threads, link, userFacingGson, multiTenancyStrategy, (IndexLayoutStrategy)indexLayoutStrategyHolder.get(), typeNameMapping, failureHandler, timingSource, this.generalPurposeOrchestrator);
        this.indexNamesRegistry = new IndexNamesRegistry();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.eventContext.render() + "]";
    }

    public void start(BackendStartContext context) {
        this.threads.onStart(context.configurationPropertySource(), context.threadPoolProvider());
        this.link.onStart(context.configurationPropertySource());
        this.generalPurposeOrchestrator.start(context.configurationPropertySource());
    }

    public CompletableFuture<?> preStop() {
        return this.generalPurposeOrchestrator.preStop();
    }

    public void stop() {
        try (Closer closer = new Closer();){
            closer.push(AbstractWorkOrchestrator::stop, (Object)this.generalPurposeOrchestrator);
            closer.push(ElasticsearchLinkImpl::onStop, (Object)this.link);
            closer.push(BeanHolder::close, this.indexLayoutStrategyHolder);
            closer.push(BackendThreads::onStop, (Object)this.threads);
        }
        catch (IOException | RuntimeException e) {
            throw log.failedToShutdownBackend(e, this.eventContext);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(ElasticsearchBackend.class)) {
            return (T)this;
        }
        throw log.backendUnwrappingWithUnknownType(clazz, ElasticsearchBackend.class, this.eventContext);
    }

    public Backend toAPI() {
        return this;
    }

    @Override
    public <T> T client(Class<T> clientClass) {
        return this.link.getClient().unwrap(clientClass);
    }

    public IndexManagerBuilder createIndexManagerBuilder(String hibernateSearchIndexName, String mappedTypeName, boolean multiTenancyEnabled, BackendBuildContext buildContext, ConfigurationPropertySource propertySource) {
        if (multiTenancyEnabled && !this.multiTenancyStrategy.isMultiTenancySupported()) {
            throw log.multiTenancyRequiredButNotSupportedByBackend(hibernateSearchIndexName, this.eventContext);
        }
        EventContext indexEventContext = EventContexts.fromIndexName((String)hibernateSearchIndexName);
        IndexNames indexNames = this.createIndexNames(indexEventContext, hibernateSearchIndexName, mappedTypeName);
        ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry = this.createAnalysisDefinitionRegistry(buildContext, indexEventContext, propertySource);
        return new ElasticsearchIndexManagerBuilder(this.indexManagerBackendContext, this.createIndexSchemaRootNodeBuilder(indexEventContext, indexNames, mappedTypeName, analysisDefinitionRegistry), this.createDocumentMetadataContributors(mappedTypeName));
    }

    private IndexNames createIndexNames(EventContext indexEventContext, String hibernateSearchIndexName, String mappedTypeName) {
        URLEncodedString readAlias;
        IndexLayoutStrategy indexLayoutStrategy = (IndexLayoutStrategy)this.indexLayoutStrategyHolder.get();
        URLEncodedString writeAlias = IndexNames.encodeName(indexLayoutStrategy.createWriteAlias(hibernateSearchIndexName));
        if (writeAlias.equals(readAlias = IndexNames.encodeName(indexLayoutStrategy.createReadAlias(hibernateSearchIndexName)))) {
            throw log.sameWriteAndReadAliases(writeAlias, indexEventContext);
        }
        IndexNames indexNames = new IndexNames(hibernateSearchIndexName, writeAlias, readAlias);
        this.indexNamesRegistry.register(indexNames);
        this.typeNameMapping.register(indexNames, mappedTypeName);
        return indexNames;
    }

    private ElasticsearchIndexSchemaRootNodeBuilder createIndexSchemaRootNodeBuilder(EventContext indexEventContext, IndexNames indexNames, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry) {
        ElasticsearchIndexSchemaRootNodeBuilder builder = new ElasticsearchIndexSchemaRootNodeBuilder(this.typeFactoryProvider, indexEventContext, indexNames, mappedTypeName, analysisDefinitionRegistry);
        this.typeNameMapping.getIndexSchemaRootContributor().ifPresent(builder::addSchemaRootContributor);
        this.multiTenancyStrategy.indexSchemaRootContributor().ifPresent(builder::addSchemaRootContributor);
        return builder;
    }

    private ElasticsearchAnalysisDefinitionRegistry createAnalysisDefinitionRegistry(BackendBuildContext buildContext, EventContext indexEventContext, ConfigurationPropertySource propertySource) {
        try {
            BeanResolver beanResolver = buildContext.beanResolver();
            return ANALYSIS_CONFIGURER.getAndMap(propertySource, arg_0 -> ((BeanResolver)beanResolver).resolve(arg_0)).map(holder -> {
                try (BeanHolder configurerHolder = holder;){
                    ElasticsearchAnalysisConfigurationContextImpl collector = new ElasticsearchAnalysisConfigurationContextImpl();
                    ((ElasticsearchAnalysisConfigurer)configurerHolder.get()).configure(collector);
                    ElasticsearchAnalysisDefinitionRegistry elasticsearchAnalysisDefinitionRegistry = new ElasticsearchAnalysisDefinitionRegistry(collector);
                    return elasticsearchAnalysisDefinitionRegistry;
                }
            }).orElseGet(ElasticsearchAnalysisDefinitionRegistry::new);
        }
        catch (Exception e) {
            throw log.unableToApplyAnalysisConfiguration(e.getMessage(), e, indexEventContext);
        }
    }

    private List<DocumentMetadataContributor> createDocumentMetadataContributors(String mappedTypeName) {
        ArrayList<DocumentMetadataContributor> contributors = new ArrayList<DocumentMetadataContributor>();
        this.typeNameMapping.getDocumentMetadataContributor(mappedTypeName).ifPresent(contributors::add);
        this.multiTenancyStrategy.documentMetadataContributor().ifPresent(contributors::add);
        return contributors;
    }
}

