/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientUtils;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClient;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.dialect.impl.ElasticsearchDialectFactory;
import org.hibernate.search.backend.elasticsearch.dialect.protocol.impl.ElasticsearchProtocolDialect;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.link.impl.ElasticsearchLink;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.metadata.impl.ElasticsearchIndexMetadataSyntax;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.backend.elasticsearch.resources.impl.BackendThreads;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultExtractorFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class ElasticsearchLinkImpl
implements ElasticsearchLink {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<Integer> SCROLL_TIMEOUT = ConfigurationProperty.forKey((String)"scroll_timeout").asInteger().withDefault((Object)60).build();
    private final BeanHolder<? extends ElasticsearchClientFactory> clientFactoryHolder;
    private final BackendThreads threads;
    private final GsonProvider defaultGsonProvider;
    private final boolean logPrettyPrinting;
    private final ElasticsearchDialectFactory dialectFactory;
    private final Optional<ElasticsearchVersion> configuredVersionOptional;
    private final boolean versionCheckEnabled;
    private ElasticsearchClientImplementor clientImplementor;
    private ElasticsearchVersion elasticsearchVersion;
    private GsonProvider gsonProvider;
    private ElasticsearchIndexMetadataSyntax indexMetadataSyntax;
    private ElasticsearchSearchSyntax searchSyntax;
    private ElasticsearchWorkBuilderFactory workBuilderFactory;
    private ElasticsearchSearchResultExtractorFactory searchResultExtractorFactory;
    private Integer scrollTimeout;

    ElasticsearchLinkImpl(BeanHolder<? extends ElasticsearchClientFactory> clientFactoryHolder, BackendThreads threads, GsonProvider defaultGsonProvider, boolean logPrettyPrinting, ElasticsearchDialectFactory dialectFactory, Optional<ElasticsearchVersion> configuredVersionOptional, boolean versionCheckEnabled) {
        this.clientFactoryHolder = clientFactoryHolder;
        this.threads = threads;
        this.defaultGsonProvider = defaultGsonProvider;
        this.logPrettyPrinting = logPrettyPrinting;
        this.dialectFactory = dialectFactory;
        this.configuredVersionOptional = configuredVersionOptional;
        this.versionCheckEnabled = versionCheckEnabled;
    }

    @Override
    public ElasticsearchClient getClient() {
        this.checkStarted();
        return this.clientImplementor;
    }

    @Override
    public GsonProvider getGsonProvider() {
        this.checkStarted();
        return this.gsonProvider;
    }

    @Override
    public ElasticsearchIndexMetadataSyntax getIndexMetadataSyntax() {
        this.checkStarted();
        return this.indexMetadataSyntax;
    }

    @Override
    public ElasticsearchSearchSyntax getSearchSyntax() {
        this.checkStarted();
        return this.searchSyntax;
    }

    @Override
    public ElasticsearchWorkBuilderFactory getWorkBuilderFactory() {
        this.checkStarted();
        return this.workBuilderFactory;
    }

    @Override
    public ElasticsearchSearchResultExtractorFactory getSearchResultExtractorFactory() {
        this.checkStarted();
        return this.searchResultExtractorFactory;
    }

    @Override
    public Integer getScrollTimeout() {
        this.checkStarted();
        return this.scrollTimeout;
    }

    ElasticsearchVersion getElasticsearchVersion() {
        this.checkStarted();
        return this.elasticsearchVersion;
    }

    void onStart(ConfigurationPropertySource propertySource) {
        if (this.clientImplementor == null) {
            this.clientImplementor = ((ElasticsearchClientFactory)this.clientFactoryHolder.get()).create(propertySource, this.threads.getThreadProvider(), this.threads.getPrefix(), this.threads.getWorkExecutor(), this.defaultGsonProvider);
            this.clientFactoryHolder.close();
            if (this.versionCheckEnabled) {
                ElasticsearchVersion configuredVersion;
                this.elasticsearchVersion = ElasticsearchClientUtils.getElasticsearchVersion(this.clientImplementor);
                if (this.configuredVersionOptional.isPresent() && !(configuredVersion = this.configuredVersionOptional.get()).matches(this.elasticsearchVersion)) {
                    throw log.unexpectedElasticsearchVersion(configuredVersion, this.elasticsearchVersion);
                }
            } else {
                this.configuredVersionOptional.ifPresent(version -> {
                    this.elasticsearchVersion = version;
                });
            }
            ElasticsearchProtocolDialect protocolDialect = this.dialectFactory.createProtocolDialect(this.elasticsearchVersion);
            this.gsonProvider = GsonProvider.create(GsonBuilder::new, this.logPrettyPrinting);
            this.indexMetadataSyntax = protocolDialect.createIndexMetadataSyntax();
            this.searchSyntax = protocolDialect.createSearchSyntax();
            this.workBuilderFactory = protocolDialect.createWorkBuilderFactory(this.gsonProvider);
            this.searchResultExtractorFactory = protocolDialect.createSearchResultExtractorFactory();
            this.scrollTimeout = (Integer)SCROLL_TIMEOUT.get(propertySource);
        }
    }

    void onStop() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.clientFactoryHolder);
            closer.push(Closeable::close, (Object)this.clientImplementor);
        }
    }

    private void checkStarted() {
        if (this.clientImplementor == null) {
            throw new AssertionFailure("Attempt to retrieve Elasticsearch client or related information before the backend was started.There is probably a bug in Hibernate Search, please report it.");
        }
    }
}

