/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.util.common.data.Range;
import org.hibernate.search.util.common.data.RangeBoundInclusion;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchRangePredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final JsonObjectAccessor RANGE_ACCESSOR = JsonAccessor.root().property("range").asObject();
    private static final JsonAccessor<JsonElement> GT_ACCESSOR = JsonAccessor.root().property("gt");
    private static final JsonAccessor<JsonElement> GTE_ACCESSOR = JsonAccessor.root().property("gte");
    private static final JsonAccessor<JsonElement> LT_ACCESSOR = JsonAccessor.root().property("lt");
    private static final JsonAccessor<JsonElement> LTE_ACCESSOR = JsonAccessor.root().property("lte");
    private final Range<JsonElement> range;

    private ElasticsearchRangePredicate(Builder<?> builder) {
        super(builder);
        this.range = ((Builder)builder).range;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        Optional upperBoundValue;
        JsonAccessor<JsonElement> accessor;
        Optional lowerBoundValue = this.range.lowerBoundValue();
        if (lowerBoundValue.isPresent()) {
            accessor = RangeBoundInclusion.EXCLUDED.equals((Object)this.range.lowerBoundInclusion()) ? GT_ACCESSOR : GTE_ACCESSOR;
            accessor.set(innerObject, (JsonElement)lowerBoundValue.get());
        }
        if ((upperBoundValue = this.range.upperBoundValue()).isPresent()) {
            accessor = RangeBoundInclusion.EXCLUDED.equals((Object)this.range.upperBoundInclusion()) ? LT_ACCESSOR : LTE_ACCESSOR;
            accessor.set(innerObject, (JsonElement)upperBoundValue.get());
        }
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        RANGE_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private static class Builder<F>
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements RangePredicateBuilder {
        private final ElasticsearchSearchValueFieldContext<F> field;
        private final ElasticsearchFieldCodec<F> codec;
        private Range<JsonElement> range;

        private Builder(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            super(searchContext, field);
            this.codec = codec;
            this.field = field;
        }

        public void range(Range<?> range, ValueConvert convertLowerBound, ValueConvert convertUpperBound) {
            this.range = Range.between((Object)this.convertToFieldValue(range.lowerBoundValue(), convertLowerBound), (RangeBoundInclusion)range.lowerBoundInclusion(), (Object)this.convertToFieldValue(range.upperBoundValue(), convertUpperBound), (RangeBoundInclusion)range.upperBoundInclusion());
        }

        public SearchPredicate build() {
            this.field.type().searchAnalyzerName();
            this.field.type().normalizerName();
            return new ElasticsearchRangePredicate(this);
        }

        private JsonElement convertToFieldValue(Optional<?> valueOptional, ValueConvert convert) {
            if (!valueOptional.isPresent()) {
                return null;
            }
            Object value = valueOptional.get();
            DslConverter<?, F> toFieldValueConverter = this.field.type().dslConverter(convert);
            try {
                Object converted = toFieldValueConverter.convertUnknown(value, this.searchContext.toDocumentFieldValueConvertContext());
                return this.codec.encode(converted);
            }
            catch (RuntimeException e) {
                throw log.cannotConvertDslParameter(e.getMessage(), e, EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath));
            }
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory<RangePredicateBuilder, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public RangePredicateBuilder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            return new Builder(this.codec, searchContext, field);
        }
    }
}

