/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexesContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchCompositeProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.DocumentReferenceExtractionHelper;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeBiFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeListProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchCompositeTriFunctionProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchDocumentReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchEntityReferenceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchExplanationProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchJsonHitProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchScoreProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchSourceProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTypeKeys;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.SearchProjectionBackendContext;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DistanceToFieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.EntityReferenceProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ScoreProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.SearchProjectionBuilderFactory;
import org.hibernate.search.util.common.function.TriFunction;

public class ElasticsearchSearchProjectionBuilderFactory
implements SearchProjectionBuilderFactory {
    private final ElasticsearchSearchContext searchContext;
    private final ElasticsearchSearchIndexesContext indexes;
    private final DocumentReferenceExtractionHelper documentReferenceExtractionHelper;

    public ElasticsearchSearchProjectionBuilderFactory(SearchProjectionBackendContext searchProjectionBackendContext, ElasticsearchSearchContext searchContext) {
        this.searchContext = searchContext;
        this.indexes = searchContext.indexes();
        this.documentReferenceExtractionHelper = searchProjectionBackendContext.createDocumentReferenceExtractionHelper(searchContext);
    }

    public DocumentReferenceProjectionBuilder documentReference() {
        return new ElasticsearchDocumentReferenceProjection.Builder(this.searchContext, this.documentReferenceExtractionHelper);
    }

    public <T> FieldProjectionBuilder<T> field(String absoluteFieldPath, Class<T> expectedType, ValueConvert convert) {
        ElasticsearchSearchValueFieldContext<?> field = this.indexes.field(absoluteFieldPath);
        field.nestedPathHierarchy();
        return this.indexes.field(absoluteFieldPath).queryElement(ProjectionTypeKeys.FIELD, this.searchContext).type(expectedType, convert);
    }

    public <E> EntityProjectionBuilder<E> entity() {
        return new ElasticsearchEntityProjection.Builder(this.searchContext, this.documentReferenceExtractionHelper);
    }

    public <R> EntityReferenceProjectionBuilder<R> entityReference() {
        return new ElasticsearchEntityReferenceProjection.Builder(this.searchContext, this.documentReferenceExtractionHelper);
    }

    public ScoreProjectionBuilder score() {
        return new ElasticsearchScoreProjection.Builder(this.searchContext);
    }

    public DistanceToFieldProjectionBuilder distance(String absoluteFieldPath) {
        ElasticsearchSearchValueFieldContext<?> field = this.indexes.field(absoluteFieldPath);
        field.nestedPathHierarchy();
        return field.queryElement(ProjectionTypeKeys.DISTANCE, this.searchContext);
    }

    public <P> CompositeProjectionBuilder<P> composite(Function<List<?>, P> transformer, SearchProjection<?> ... projections) {
        ArrayList typedProjections = new ArrayList(projections.length);
        for (SearchProjection<?> projection : projections) {
            typedProjections.add(this.toImplementation(projection));
        }
        return new AbstractElasticsearchCompositeProjection.Builder<P>(new ElasticsearchCompositeListProjection<P>(this.searchContext, transformer, typedProjections));
    }

    public <P1, P> CompositeProjectionBuilder<P> composite(Function<P1, P> transformer, SearchProjection<P1> projection) {
        return new AbstractElasticsearchCompositeProjection.Builder(new ElasticsearchCompositeFunctionProjection<P1, P>(this.searchContext, transformer, this.toImplementation(projection)));
    }

    public <P1, P2, P> CompositeProjectionBuilder<P> composite(BiFunction<P1, P2, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2) {
        return new AbstractElasticsearchCompositeProjection.Builder(new ElasticsearchCompositeBiFunctionProjection<P1, P2, P>(this.searchContext, transformer, this.toImplementation(projection1), this.toImplementation(projection2)));
    }

    public <P1, P2, P3, P> CompositeProjectionBuilder<P> composite(TriFunction<P1, P2, P3, P> transformer, SearchProjection<P1> projection1, SearchProjection<P2> projection2, SearchProjection<P3> projection3) {
        return new AbstractElasticsearchCompositeProjection.Builder(new ElasticsearchCompositeTriFunctionProjection<P1, P2, P3, P>(this.searchContext, transformer, this.toImplementation(projection1), this.toImplementation(projection2), this.toImplementation(projection3)));
    }

    public SearchProjectionBuilder<JsonObject> source() {
        return new ElasticsearchSourceProjection.Builder(this.searchContext);
    }

    public SearchProjectionBuilder<JsonObject> explanation() {
        return new ElasticsearchExplanationProjection.Builder(this.searchContext);
    }

    public SearchProjectionBuilder<JsonObject> jsonHit() {
        return new ElasticsearchJsonHitProjection.Builder(this.searchContext);
    }

    private <T> ElasticsearchSearchProjection<?, T> toImplementation(SearchProjection<T> projection) {
        return ElasticsearchSearchProjection.from(this.searchContext, projection);
    }
}

