/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.query.impl;

import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchParallelWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchScroll;
import org.hibernate.search.backend.elasticsearch.search.query.ElasticsearchSearchScrollResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchLoadableSearchResult;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchResultImpl;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchScrollResultImpl;
import org.hibernate.search.backend.elasticsearch.search.timeout.impl.ElasticsearchTimeoutManager;
import org.hibernate.search.backend.elasticsearch.work.builder.factory.impl.ElasticsearchWorkBuilderFactory;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.SearchWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.NonBulkableWork;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Futures;

public class ElasticsearchSearchScrollImpl<H>
implements ElasticsearchSearchScroll<H> {
    private final ElasticsearchParallelWorkOrchestrator queryOrchestrator;
    private final ElasticsearchWorkBuilderFactory workFactory;
    private final ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor;
    private final String scrollTimeoutString;
    private final SearchWorkBuilder<ElasticsearchLoadableSearchResult<H>> firstScroll;
    private final ElasticsearchTimeoutManager timeoutManager;
    private String scrollId;

    public ElasticsearchSearchScrollImpl(ElasticsearchParallelWorkOrchestrator queryOrchestrator, ElasticsearchWorkBuilderFactory workFactory, ElasticsearchSearchResultExtractor<ElasticsearchLoadableSearchResult<H>> searchResultExtractor, String scrollTimeoutString, SearchWorkBuilder<ElasticsearchLoadableSearchResult<H>> firstScroll, ElasticsearchTimeoutManager timeoutManager) {
        this.workFactory = workFactory;
        this.queryOrchestrator = queryOrchestrator;
        this.searchResultExtractor = searchResultExtractor;
        this.scrollTimeoutString = scrollTimeoutString;
        this.firstScroll = firstScroll;
        this.timeoutManager = timeoutManager;
    }

    public void close() {
        if (this.scrollId != null) {
            Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit((NonBulkableWork)this.workFactory.clearScroll(this.scrollId).build()));
        }
    }

    public ElasticsearchSearchScrollResult<H> next() {
        this.timeoutManager.start();
        NonBulkableWork scroll = this.scrollId == null ? (NonBulkableWork)this.firstScroll.build() : (NonBulkableWork)this.workFactory.scroll(this.scrollId, this.scrollTimeoutString, this.searchResultExtractor, this.timeoutManager).build();
        ElasticsearchLoadableSearchResult loadableSearchResult = (ElasticsearchLoadableSearchResult)Futures.unwrappedExceptionJoin(this.queryOrchestrator.submit(scroll));
        ElasticsearchSearchResultImpl searchResult = loadableSearchResult.loadBlocking();
        this.scrollId = searchResult.scrollId();
        if (this.scrollId == null) {
            throw new AssertionFailure("Elasticsearch response lacked a value for scroll id");
        }
        this.timeoutManager.stop();
        return new ElasticsearchSearchScrollResultImpl(loadableSearchResult.hasHits(), searchResult.hits(), searchResult.took(), searchResult.timedOut());
    }
}

