/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;

public abstract class AbstractElasticsearchReversibleSort
extends AbstractElasticsearchSort {
    private static final JsonAccessor<JsonElement> ORDER_ACCESSOR = JsonAccessor.root().property("order");
    private static final JsonPrimitive ASC_KEYWORD_JSON = new JsonPrimitive("asc");
    private static final JsonPrimitive DESC_KEYWORD_JSON = new JsonPrimitive("desc");
    private final SortOrder order;

    protected AbstractElasticsearchReversibleSort(AbstractBuilder builder) {
        super(builder);
        this.order = builder.order;
    }

    @Override
    public final void toJsonSorts(ElasticsearchSearchSortCollector collector) {
        JsonObject innerObject = new JsonObject();
        if (this.order != null) {
            switch (this.order) {
                case ASC: {
                    ORDER_ACCESSOR.set(innerObject, (JsonElement)ASC_KEYWORD_JSON);
                    break;
                }
                case DESC: {
                    ORDER_ACCESSOR.set(innerObject, (JsonElement)DESC_KEYWORD_JSON);
                }
            }
        }
        this.enrichInnerObject(collector, innerObject);
        this.doToJsonSorts(collector, innerObject);
    }

    protected void enrichInnerObject(ElasticsearchSearchSortCollector collector, JsonObject innerObject) {
    }

    protected abstract void doToJsonSorts(ElasticsearchSearchSortCollector var1, JsonObject var2);

    public static abstract class AbstractBuilder
    extends AbstractElasticsearchSort.AbstractBuilder {
        private SortOrder order;

        protected AbstractBuilder(ElasticsearchSearchContext searchContext) {
            super(searchContext);
        }

        public void order(SortOrder order) {
            this.order = order;
        }
    }
}

