/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.timeout.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.timeout.spi.RequestDeadline;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.search.timeout.spi.TimeoutManager;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ElasticsearchTimeoutManager
extends TimeoutManager
implements RequestDeadline {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Long timeoutValue;
    private final TimeUnit timeoutUnit;
    private final JsonObject query;

    public static ElasticsearchTimeoutManager noTimeout(TimingSource timingSource, JsonObject query) {
        return new ElasticsearchTimeoutManager(timingSource, query, null, null, TimeoutManager.Type.NONE);
    }

    public static ElasticsearchTimeoutManager softTimeout(TimingSource timingSource, JsonObject query, long timeout, TimeUnit timeUnit) {
        return new ElasticsearchTimeoutManager(timingSource, query, timeout, timeUnit, TimeoutManager.Type.LIMIT);
    }

    public static ElasticsearchTimeoutManager hardTimeout(TimingSource timingSource, JsonObject query, long timeout, TimeUnit timeUnit) {
        return new ElasticsearchTimeoutManager(timingSource, query, timeout, timeUnit, TimeoutManager.Type.EXCEPTION);
    }

    private ElasticsearchTimeoutManager(TimingSource timingSource, JsonObject query, Long timeoutValue, TimeUnit timeoutUnit, TimeoutManager.Type type) {
        super(timingSource, timeoutUnit == null ? null : Long.valueOf(timeoutUnit.toMillis(timeoutValue)), type);
        this.timeoutValue = timeoutValue;
        this.timeoutUnit = timeoutUnit;
        this.query = query;
    }

    protected void onTimedOut() {
        if (this.hasHardTimeout()) {
            throw log.clientSideTimedOut(Duration.ofNanos(this.timeoutUnit.toNanos(this.timeoutValue)), this.query.toString());
        }
    }

    public boolean defined() {
        return this.timeoutValue != null && this.timeoutUnit != null;
    }

    public String timeoutString() {
        return this.checkTimeLeftInMilliseconds() + "ms";
    }
}

