/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoPoint;

public class ElasticsearchGeoPointSpatialWithinCirclePredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor GEO_DISTANCE_ACCESSOR = JsonAccessor.root().property("geo_distance").asObject();
    private static final JsonAccessor<Double> DISTANCE_ACCESSOR = JsonAccessor.root().property("distance").asDouble();
    private final double distanceInMeters;
    private final JsonElement center;

    private ElasticsearchGeoPointSpatialWithinCirclePredicate(Builder builder) {
        super(builder);
        this.distanceInMeters = builder.distanceInMeters;
        this.center = builder.center;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        DISTANCE_ACCESSOR.set(innerObject, this.distanceInMeters);
        innerObject.add(this.absoluteFieldPath, this.center);
        GEO_DISTANCE_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements SpatialWithinCirclePredicateBuilder {
        private final ElasticsearchFieldCodec<GeoPoint> codec;
        private double distanceInMeters;
        private JsonElement center;

        private Builder(ElasticsearchFieldCodec<GeoPoint> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<GeoPoint> field) {
            super(searchContext, field);
            this.codec = codec;
        }

        public void circle(GeoPoint center, double radius, DistanceUnit unit) {
            this.distanceInMeters = unit.toMeters(radius);
            this.center = this.codec.encode(center);
        }

        public SearchPredicate build() {
            return new ElasticsearchGeoPointSpatialWithinCirclePredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory<SpatialWithinCirclePredicateBuilder, GeoPoint> {
        public Factory(ElasticsearchFieldCodec<GeoPoint> codec) {
            super(codec);
        }

        @Override
        public Builder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<GeoPoint> field) {
            return new Builder(this.codec, searchContext, field);
        }
    }
}

