/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.execution.impl;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.hibernate.search.backend.elasticsearch.orchestration.impl.ElasticsearchSerialWorkOrchestrator;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.util.common.impl.Futures;

class ElasticsearchIndexIndexingPlanExecution<R> {
    private final ElasticsearchSerialWorkOrchestrator orchestrator;
    private final EntityReferenceFactory<R> entityReferenceFactory;
    private final List<SingleDocumentIndexingWork> works;
    private final CompletableFuture<Void>[] futures;

    ElasticsearchIndexIndexingPlanExecution(ElasticsearchSerialWorkOrchestrator orchestrator, EntityReferenceFactory<R> entityReferenceFactory, List<SingleDocumentIndexingWork> works) {
        this.orchestrator = orchestrator;
        this.entityReferenceFactory = entityReferenceFactory;
        this.works = works;
        this.futures = new CompletableFuture[works.size()];
        for (int i = 0; i < this.futures.length; ++i) {
            this.futures[i] = new CompletableFuture();
        }
    }

    CompletableFuture<IndexIndexingPlanExecutionReport<R>> execute() {
        CompletionStage reportFuture = CompletableFuture.allOf(this.futures).handle((result, throwable) -> this.onAllWorksFinished());
        for (int i = 0; i < this.works.size(); ++i) {
            CompletableFuture<Void> future = this.futures[i];
            SingleDocumentIndexingWork work = this.works.get(i);
            this.orchestrator.submit(future, work);
        }
        return reportFuture;
    }

    private IndexIndexingPlanExecutionReport<R> onAllWorksFinished() {
        return this.buildReport();
    }

    private IndexIndexingPlanExecutionReport<R> buildReport() {
        IndexIndexingPlanExecutionReport.Builder reportBuilder = IndexIndexingPlanExecutionReport.builder();
        for (int i = 0; i < this.futures.length; ++i) {
            CompletableFuture<Void> future = this.futures[i];
            if (!future.isCompletedExceptionally()) continue;
            reportBuilder.throwable(Futures.getThrowableNow(future));
            SingleDocumentIndexingWork work = this.works.get(i);
            try {
                reportBuilder.failingEntityReference(this.entityReferenceFactory, work.getEntityTypeName(), work.getEntityIdentifier());
                continue;
            }
            catch (RuntimeException e) {
                reportBuilder.throwable((Throwable)e);
            }
        }
        return reportBuilder.build();
    }
}

