/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.ExplainWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.result.impl.ExplainResult;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ExplainWork
extends AbstractNonBulkableWork<ExplainResult> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ElasticsearchRequestSuccessAssessor SUCCESS_ASSESSOR = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();
    private final URLEncodedString id;

    private ExplainWork(Builder builder) {
        super(builder);
        this.id = builder.id;
    }

    @Override
    protected ExplainResult generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        if (response.statusCode() == 404) {
            throw log.explainUnknownDocument(this.id);
        }
        JsonObject body = response.body();
        return new ExplainResultImpl(body);
    }

    private static class ExplainResultImpl
    implements ExplainResult {
        private final JsonObject jsonObject;

        private ExplainResultImpl(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        @Override
        public JsonObject getJsonObject() {
            return this.jsonObject;
        }
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder>
    implements ExplainWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final URLEncodedString id;
        private final JsonObject payload;
        private Set<String> routingKeys;

        public static Builder forElasticsearch67AndBelow(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id, JsonObject payload) {
            return new Builder(indexName, typeName, id, payload);
        }

        public static Builder forElasticsearch7AndAbove(URLEncodedString indexName, URLEncodedString id, JsonObject payload) {
            return new Builder(indexName, null, id, payload);
        }

        private Builder(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id, JsonObject payload) {
            super(SUCCESS_ASSESSOR);
            this.indexName = indexName;
            this.typeName = typeName;
            this.id = id;
            this.payload = payload;
        }

        @Override
        public Builder routingKeys(Set<String> routingKeys) {
            this.routingKeys = routingKeys;
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(this.indexName);
            if (this.typeName != null) {
                builder.pathComponent(this.typeName).pathComponent(this.id).pathComponent(Paths._EXPLAIN);
            } else {
                builder.pathComponent(Paths._EXPLAIN).pathComponent(this.id);
            }
            builder.body(this.payload);
            if (!this.routingKeys.isEmpty()) {
                builder.multiValuedParam("routing", this.routingKeys);
            }
            return builder.build();
        }

        @Override
        public ExplainWork build() {
            return new ExplainWork(this);
        }
    }
}

