/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.index.IndexStatus;
import org.hibernate.search.backend.elasticsearch.search.timeout.spi.RequestDeadline;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.WaitForIndexStatusWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;

public class WaitForIndexStatusWork
extends AbstractNonBulkableWork<Void> {
    protected WaitForIndexStatusWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        return null;
    }

    public static class Builder
    extends AbstractNonBulkableWork.AbstractBuilder<Builder>
    implements WaitForIndexStatusWorkBuilder {
        private final URLEncodedString indexName;
        private final IndexStatus requiredStatus;
        private final int requiredStatusTimeoutInMs;

        public Builder(URLEncodedString indexName, IndexStatus requiredStatus, int requiredStatusTimeoutInMs) {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.requiredStatus = requiredStatus;
            this.requiredStatusTimeoutInMs = requiredStatusTimeoutInMs;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().pathComponent(Paths._CLUSTER).pathComponent(Paths.HEALTH).pathComponent(this.indexName).param("wait_for_status", this.requiredStatus.externalRepresentation()).param("timeout", this.requiredStatusTimeoutInMs + "ms");
            builder.requestDeadline(new RequestDeadline.ImmutableRequestDeadline(this.requiredStatusTimeoutInMs));
            return builder.build();
        }

        @Override
        public WaitForIndexStatusWork build() {
            return new WaitForIndexStatusWork(this);
        }
    }
}

