/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.hibernate.search.backend.elasticsearch.cfg.ElasticsearchBackendSettings;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchClientImpl;
import org.hibernate.search.backend.elasticsearch.client.impl.ElasticsearchHttpClientConfigurationContextImpl;
import org.hibernate.search.backend.elasticsearch.client.impl.ServerUris;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientFactory;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchClientImplementor;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchHttpClientConfigurer;
import org.hibernate.search.backend.elasticsearch.gson.spi.GsonProvider;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class ElasticsearchClientFactoryImpl
implements ElasticsearchClientFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    public static final BeanReference<ElasticsearchClientFactory> REFERENCE = beanResolver -> {
        List httpClientConfigurerReferences = beanResolver.allConfiguredForRole(ElasticsearchHttpClientConfigurer.class);
        BeanHolder httpClientConfigurerHolders = beanResolver.resolve(httpClientConfigurerReferences);
        try {
            ElasticsearchClientFactoryImpl factory = new ElasticsearchClientFactoryImpl((List)httpClientConfigurerHolders.get());
            return BeanHolder.of((Object)factory).withDependencyAutoClosing(new BeanHolder[]{httpClientConfigurerHolders});
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push((AutoCloseable)httpClientConfigurerHolders);
            throw e;
        }
    };
    private static final ConfigurationProperty<List<String>> HOSTS = ConfigurationProperty.forKey((String)"hosts").asString().multivalued().withDefault(ElasticsearchBackendSettings.Defaults.HOSTS).build();
    private static final ConfigurationProperty<String> PROTOCOL = ConfigurationProperty.forKey((String)"protocol").asString().withDefault((Object)"http").build();
    private static final OptionalConfigurationProperty<String> USERNAME = ConfigurationProperty.forKey((String)"username").asString().build();
    private static final OptionalConfigurationProperty<String> PASSWORD = ConfigurationProperty.forKey((String)"password").asString().build();
    private static final OptionalConfigurationProperty<Integer> REQUEST_TIMEOUT = ConfigurationProperty.forKey((String)"request_timeout").asInteger().build();
    private static final ConfigurationProperty<Integer> READ_TIMEOUT = ConfigurationProperty.forKey((String)"read_timeout").asInteger().withDefault((Object)30000).build();
    private static final ConfigurationProperty<Integer> CONNECTION_TIMEOUT = ConfigurationProperty.forKey((String)"connection_timeout").asInteger().withDefault((Object)1000).build();
    private static final ConfigurationProperty<Integer> MAX_TOTAL_CONNECTION = ConfigurationProperty.forKey((String)"max_connections").asInteger().withDefault((Object)20).build();
    private static final ConfigurationProperty<Integer> MAX_TOTAL_CONNECTION_PER_ROUTE = ConfigurationProperty.forKey((String)"max_connections_per_route").asInteger().withDefault((Object)10).build();
    private static final ConfigurationProperty<Boolean> DISCOVERY_ENABLED = ConfigurationProperty.forKey((String)"discovery.enabled").asBoolean().withDefault((Object)false).build();
    private static final ConfigurationProperty<Integer> DISCOVERY_REFRESH_INTERVAL = ConfigurationProperty.forKey((String)"discovery.refresh_interval").asInteger().withDefault((Object)10).build();
    private final List<ElasticsearchHttpClientConfigurer> httpClientConfigurers;

    ElasticsearchClientFactoryImpl(List<ElasticsearchHttpClientConfigurer> httpClientConfigurers) {
        this.httpClientConfigurers = httpClientConfigurers;
    }

    @Override
    public ElasticsearchClientImplementor create(BeanResolver beanResolver, ConfigurationPropertySource propertySource, ThreadProvider threadProvider, String threadNamePrefix, ScheduledExecutorService timeoutExecutorService, GsonProvider gsonProvider) {
        Optional requestTimeoutMs = (Optional)REQUEST_TIMEOUT.get(propertySource);
        int connectionTimeoutMs = (Integer)CONNECTION_TIMEOUT.get(propertySource);
        ServerUris hosts = ServerUris.fromStrings((String)PROTOCOL.get(propertySource), (List)HOSTS.get(propertySource));
        RestClient restClient = this.createClient(beanResolver, propertySource, threadProvider, threadNamePrefix, hosts);
        Sniffer sniffer = this.createSniffer(propertySource, restClient, hosts);
        return new ElasticsearchClientImpl(restClient, sniffer, timeoutExecutorService, requestTimeoutMs, connectionTimeoutMs, gsonProvider.getGson(), gsonProvider.getLogHelper());
    }

    private RestClient createClient(BeanResolver beanResolver, ConfigurationPropertySource propertySource, ThreadProvider threadProvider, String threadNamePrefix, ServerUris hosts) {
        return RestClient.builder((HttpHost[])hosts.asHostsArray()).setRequestConfigCallback(b -> this.customizeRequestConfig(b, propertySource)).setHttpClientConfigCallback(b -> this.customizeHttpClientConfig(b, beanResolver, propertySource, threadProvider, threadNamePrefix, hosts, this.httpClientConfigurers)).build();
    }

    private Sniffer createSniffer(ConfigurationPropertySource propertySource, RestClient client, ServerUris hosts) {
        boolean discoveryEnabled = (Boolean)DISCOVERY_ENABLED.get(propertySource);
        if (discoveryEnabled) {
            SnifferBuilder builder = Sniffer.builder((RestClient)client).setSniffIntervalMillis((Integer)DISCOVERY_REFRESH_INTERVAL.get(propertySource) * 1000);
            if (hosts.isSslEnabled()) {
                ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, ElasticsearchNodesSniffer.Scheme.HTTPS);
                builder.setNodesSniffer((NodesSniffer)hostsSniffer);
            }
            return builder.build();
        }
        return null;
    }

    private HttpAsyncClientBuilder customizeHttpClientConfig(HttpAsyncClientBuilder builder, BeanResolver beanResolver, ConfigurationPropertySource propertySource, ThreadProvider threadProvider, String threadNamePrefix, ServerUris hosts, Iterable<ElasticsearchHttpClientConfigurer> configurers) {
        Optional username;
        builder.setMaxConnTotal(((Integer)MAX_TOTAL_CONNECTION.get(propertySource)).intValue()).setMaxConnPerRoute(((Integer)MAX_TOTAL_CONNECTION_PER_ROUTE.get(propertySource)).intValue()).setThreadFactory(threadProvider.createThreadFactory(threadNamePrefix + " - Transport thread"));
        if (!hosts.isSslEnabled()) {
            builder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
        }
        if ((username = (Optional)USERNAME.get(propertySource)).isPresent()) {
            Optional password = (Optional)PASSWORD.get(propertySource);
            if (password.isPresent() && !hosts.isSslEnabled()) {
                log.usingPasswordOverHttp();
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials((String)username.get(), (String)password.orElse(null)));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        ElasticsearchHttpClientConfigurationContextImpl clientConfigurationContext = new ElasticsearchHttpClientConfigurationContextImpl(beanResolver, propertySource, builder);
        for (ElasticsearchHttpClientConfigurer configurer : configurers) {
            configurer.configure(clientConfigurationContext);
        }
        return builder;
    }

    private RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder, ConfigurationPropertySource propertySource) {
        return builder.setConnectionRequestTimeout(0).setSocketTimeout(((Integer)READ_TIMEOUT.get(propertySource)).intValue()).setConnectTimeout(((Integer)CONNECTION_TIMEOUT.get(propertySource)).intValue());
    }
}

