/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaObjectFieldTemplateBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaRootNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaValueFieldNodeBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.dsl.impl.ElasticsearchIndexSchemaValueFieldTemplateBuilder;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeCollector;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaNodeContributor;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.AbstractTypeMapping;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.DynamicType;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.engine.backend.common.spi.FieldPaths;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTemplateOptionsStep;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.ObjectStructure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public abstract class AbstractElasticsearchIndexSchemaObjectNodeBuilder
implements IndexSchemaObjectNodeBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, ElasticsearchIndexSchemaNodeContributor> fields = new LinkedHashMap<String, ElasticsearchIndexSchemaNodeContributor>();
    private final Map<String, ElasticsearchIndexSchemaNodeContributor> templates = new LinkedHashMap<String, ElasticsearchIndexSchemaNodeContributor>();

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "absolutePath=" + this.getAbsolutePath() + "]";
    }

    public <F> IndexSchemaFieldOptionsStep<?, IndexFieldReference<F>> addField(String relativeFieldName, IndexFieldInclusion inclusion, IndexFieldType<F> indexFieldType) {
        ElasticsearchIndexValueFieldType fieldType = (ElasticsearchIndexValueFieldType)indexFieldType;
        ElasticsearchIndexSchemaValueFieldNodeBuilder childBuilder = new ElasticsearchIndexSchemaValueFieldNodeBuilder(this, relativeFieldName, inclusion, fieldType);
        this.putField(relativeFieldName, childBuilder);
        return childBuilder;
    }

    public IndexSchemaObjectFieldNodeBuilder addObjectField(String relativeFieldName, IndexFieldInclusion inclusion, ObjectStructure structure) {
        ElasticsearchIndexSchemaObjectFieldNodeBuilder objectFieldBuilder = new ElasticsearchIndexSchemaObjectFieldNodeBuilder(this, relativeFieldName, inclusion, structure);
        this.putField(relativeFieldName, objectFieldBuilder);
        return objectFieldBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addFieldTemplate(String templateName, IndexFieldInclusion inclusion, IndexFieldType<?> indexFieldType, String prefix) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        ElasticsearchIndexValueFieldType fieldType = (ElasticsearchIndexValueFieldType)indexFieldType;
        ElasticsearchIndexSchemaValueFieldTemplateBuilder templateBuilder = new ElasticsearchIndexSchemaValueFieldTemplateBuilder(this, prefixedTemplateName, inclusion, fieldType, prefix);
        this.putTemplate(prefixedTemplateName, templateBuilder);
        return templateBuilder;
    }

    public IndexSchemaFieldTemplateOptionsStep<?> addObjectFieldTemplate(String templateName, ObjectStructure structure, String prefix, IndexFieldInclusion inclusion) {
        String prefixedTemplateName = FieldPaths.prefix((String)prefix, (String)templateName);
        ElasticsearchIndexSchemaObjectFieldTemplateBuilder templateBuilder = new ElasticsearchIndexSchemaObjectFieldTemplateBuilder(this, prefixedTemplateName, inclusion, structure, prefix);
        if (IndexFieldInclusion.INCLUDED.equals((Object)inclusion)) {
            this.putTemplate(prefixedTemplateName, templateBuilder);
        }
        return templateBuilder;
    }

    final void contributeChildren(AbstractTypeMapping mapping, ElasticsearchIndexSchemaObjectNode node, ElasticsearchIndexSchemaNodeCollector collector, List<AbstractElasticsearchIndexSchemaFieldNode> staticChildrenForParent) {
        for (Map.Entry<String, ElasticsearchIndexSchemaNodeContributor> entry : this.fields.entrySet()) {
            ElasticsearchIndexSchemaNodeContributor propertyContributor = entry.getValue();
            propertyContributor.contribute(collector, node, staticChildrenForParent, mapping);
        }
        for (ElasticsearchIndexSchemaNodeContributor template : this.templates.values()) {
            template.contribute(collector, node, staticChildrenForParent, mapping);
        }
    }

    abstract ElasticsearchIndexSchemaRootNodeBuilder getRootNodeBuilder();

    abstract String getAbsolutePath();

    final DynamicType resolveSelfDynamicType(DynamicType defaultDynamicType) {
        return this.templates.isEmpty() ? defaultDynamicType : DynamicType.TRUE;
    }

    private void putField(String name, ElasticsearchIndexSchemaNodeContributor contributor) {
        ElasticsearchIndexSchemaNodeContributor previous = this.fields.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaNodeNameConflict(name, this.eventContext());
        }
    }

    private void putTemplate(String name, ElasticsearchIndexSchemaNodeContributor contributor) {
        ElasticsearchIndexSchemaNodeContributor previous = this.templates.putIfAbsent(name, contributor);
        if (previous != null) {
            throw log.indexSchemaFieldTemplateNameConflict(name, this.eventContext());
        }
    }
}

