/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.document.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.AbstractElasticsearchIndexSchemaFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaObjectNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaValueFieldNode;
import org.hibernate.search.backend.elasticsearch.document.model.impl.ElasticsearchIndexSchemaValueFieldTemplate;
import org.hibernate.search.backend.elasticsearch.document.model.lowlevel.impl.LowLevelIndexMetadataBuilder;
import org.hibernate.search.backend.elasticsearch.index.layout.impl.IndexNames;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.RootTypeMapping;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchIndexContext;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldFilter;
import org.hibernate.search.engine.backend.document.model.spi.IndexFieldInclusion;
import org.hibernate.search.engine.backend.metamodel.IndexDescriptor;
import org.hibernate.search.engine.backend.metamodel.IndexFieldDescriptor;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.reporting.EventContext;

public class ElasticsearchIndexModel
implements IndexDescriptor,
ElasticsearchSearchIndexContext {
    private final IndexNames names;
    private final String mappedTypeName;
    private final EventContext eventContext;
    private final ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry;
    private final RootTypeMapping mapping;
    private final ToDocumentIdentifierValueConverter<?> idDslConverter;
    private final ElasticsearchIndexSchemaObjectNode rootNode;
    private final Map<String, ElasticsearchIndexSchemaObjectFieldNode> objectFieldNodes;
    private final Map<String, ElasticsearchIndexSchemaValueFieldNode<?>> valueFieldNodes;
    private final List<IndexFieldDescriptor> staticFields;
    private final List<ElasticsearchIndexSchemaObjectFieldTemplate> objectFieldTemplates;
    private final List<ElasticsearchIndexSchemaValueFieldTemplate> valueFieldTemplates;
    private final ConcurrentMap<String, ElasticsearchIndexSchemaObjectFieldNode> dynamicObjectFieldNodesCache = new ConcurrentHashMap<String, ElasticsearchIndexSchemaObjectFieldNode>();
    private final ConcurrentMap<String, ElasticsearchIndexSchemaValueFieldNode<?>> dynamicValueFieldNodesCache = new ConcurrentHashMap();

    public ElasticsearchIndexModel(IndexNames names, String mappedTypeName, ElasticsearchAnalysisDefinitionRegistry analysisDefinitionRegistry, RootTypeMapping mapping, ToDocumentIdentifierValueConverter<?> idDslConverter, ElasticsearchIndexSchemaObjectNode rootNode, Map<String, ElasticsearchIndexSchemaObjectFieldNode> objectFieldNodes, Map<String, ElasticsearchIndexSchemaValueFieldNode<?>> valueFieldNodes, List<ElasticsearchIndexSchemaObjectFieldTemplate> objectFieldTemplates, List<ElasticsearchIndexSchemaValueFieldTemplate> valueFieldTemplates) {
        this.names = names;
        this.mappedTypeName = mappedTypeName;
        this.eventContext = EventContexts.fromIndexName((String)this.hibernateSearchName());
        this.analysisDefinitionRegistry = analysisDefinitionRegistry;
        this.mapping = mapping;
        this.idDslConverter = idDslConverter;
        this.rootNode = rootNode;
        this.objectFieldNodes = objectFieldNodes;
        this.valueFieldNodes = valueFieldNodes;
        ArrayList theStaticFields = new ArrayList();
        objectFieldNodes.values().stream().filter(field -> IndexFieldInclusion.INCLUDED.equals((Object)field.inclusion())).forEach(theStaticFields::add);
        valueFieldNodes.values().stream().filter(field -> IndexFieldInclusion.INCLUDED.equals((Object)field.inclusion())).forEach(theStaticFields::add);
        this.staticFields = CollectionHelper.toImmutableList(theStaticFields);
        this.objectFieldTemplates = objectFieldTemplates;
        this.valueFieldTemplates = valueFieldTemplates;
    }

    public String hibernateSearchName() {
        return this.names.getHibernateSearch();
    }

    @Override
    public IndexNames names() {
        return this.names;
    }

    @Override
    public String mappedTypeName() {
        return this.mappedTypeName;
    }

    @Override
    public ToDocumentIdentifierValueConverter<?> idDslConverter() {
        return this.idDslConverter;
    }

    public ElasticsearchIndexSchemaObjectNode root() {
        return this.rootNode;
    }

    public Optional<IndexFieldDescriptor> field(String absolutePath) {
        AbstractElasticsearchIndexSchemaFieldNode fieldDescriptor = this.getFieldNode(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
        if (fieldDescriptor == null) {
            fieldDescriptor = this.getObjectFieldNode(absolutePath, IndexFieldFilter.INCLUDED_ONLY);
        }
        return Optional.ofNullable(fieldDescriptor);
    }

    public Collection<IndexFieldDescriptor> staticFields() {
        return this.staticFields;
    }

    public EventContext getEventContext() {
        return this.eventContext;
    }

    public ElasticsearchIndexSchemaObjectFieldNode getObjectFieldNode(String absolutePath, IndexFieldFilter filter) {
        ElasticsearchIndexSchemaObjectFieldNode node = this.getNode(this.objectFieldNodes, this.objectFieldTemplates, this.dynamicObjectFieldNodesCache, absolutePath);
        return node == null ? null : (ElasticsearchIndexSchemaObjectFieldNode)filter.filter((Object)node, node.inclusion());
    }

    public ElasticsearchIndexSchemaValueFieldNode<?> getFieldNode(String absolutePath, IndexFieldFilter filter) {
        ElasticsearchIndexSchemaValueFieldNode<?> node = this.getNode(this.valueFieldNodes, this.valueFieldTemplates, this.dynamicValueFieldNodesCache, absolutePath);
        return node == null ? null : (ElasticsearchIndexSchemaValueFieldNode)filter.filter(node, node.inclusion());
    }

    public void contributeLowLevelMetadata(LowLevelIndexMetadataBuilder builder) {
        builder.setAnalysisDefinitionRegistry(this.analysisDefinitionRegistry);
        builder.setMapping(this.mapping);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "names=" + this.names + ", mapping=" + this.mapping + "]";
    }

    private <N> N getNode(Map<String, N> staticNodes, List<? extends AbstractElasticsearchIndexSchemaFieldTemplate<N>> templates, ConcurrentMap<String, N> dynamicNodesCache, String absolutePath) {
        Object node = staticNodes.get(absolutePath);
        if (node != null) {
            return node;
        }
        node = dynamicNodesCache.get(absolutePath);
        if (node != null) {
            return node;
        }
        for (AbstractElasticsearchIndexSchemaFieldTemplate<N> template : templates) {
            node = template.createNodeIfMatching(this, absolutePath);
            if (node == null) continue;
            N previous = dynamicNodesCache.putIfAbsent(absolutePath, node);
            if (previous == null) break;
            node = previous;
            break;
        }
        return node;
    }
}

