/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchBucketAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentFieldValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.util.common.impl.CollectionHelper;

public class ElasticsearchTermsAggregation<F, K>
extends AbstractElasticsearchBucketAggregation<K, Long> {
    private final String absoluteFieldPath;
    private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;
    private final ElasticsearchFieldCodec<F> codec;
    private final JsonObject order;
    private final int size;
    private final int minDocCount;

    private ElasticsearchTermsAggregation(Builder<F, K> builder) {
        super(builder);
        this.absoluteFieldPath = builder.field.absolutePath();
        this.fromFieldValueConverter = ((Builder)builder).fromFieldValueConverter;
        this.codec = ((Builder)builder).codec;
        this.order = ((Builder)builder).order;
        this.size = ((Builder)builder).size;
        this.minDocCount = ((Builder)builder).minDocCount;
    }

    @Override
    protected void doRequest(AggregationRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        outerObject.add("terms", (JsonElement)innerObject);
        innerObject.addProperty("field", this.absoluteFieldPath);
        if (this.order != null) {
            innerObject.add("order", (JsonElement)this.order);
        }
        innerObject.addProperty("size", (Number)this.size);
        innerObject.addProperty("min_doc_count", (Number)this.minDocCount);
    }

    @Override
    protected Map<K, Long> doExtract(AggregationExtractContext context, JsonObject outerObject, JsonElement buckets) {
        JsonArray bucketArray = buckets.getAsJsonArray();
        LinkedHashMap result = CollectionHelper.newLinkedHashMap((int)bucketArray.size());
        FromDocumentFieldValueConvertContext convertContext = context.getConvertContext();
        for (JsonElement bucketElement : bucketArray) {
            JsonObject bucket = bucketElement.getAsJsonObject();
            JsonElement keyJson = bucket.get("key");
            JsonElement keyAsStringJson = bucket.get("key_as_string");
            Object key = this.fromFieldValueConverter.convert(this.codec.decodeAggregationKey(keyJson, keyAsStringJson), convertContext);
            long documentCount = this.getBucketDocCount(bucket);
            result.put(key, documentCount);
        }
        return result;
    }

    public static class Builder<F, K>
    extends AbstractElasticsearchBucketAggregation.AbstractBuilder<K, Long>
    implements TermsAggregationBuilder<K> {
        private final ElasticsearchFieldCodec<F> codec;
        private final ProjectionConverter<F, ? extends K> fromFieldValueConverter;
        private JsonObject order;
        private int minDocCount = 1;
        private int size = 100;

        private Builder(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field, ProjectionConverter<F, ? extends K> fromFieldValueConverter) {
            super(searchContext, field);
            this.codec = codec;
            this.fromFieldValueConverter = fromFieldValueConverter;
        }

        public void orderByCountDescending() {
            this.order("_count", "desc");
        }

        public void orderByCountAscending() {
            this.order("_count", "asc");
        }

        public void orderByTermAscending() {
            this.order(this.searchContext.searchSyntax().getTermAggregationOrderByTermToken(), "asc");
        }

        public void orderByTermDescending() {
            this.order(this.searchContext.searchSyntax().getTermAggregationOrderByTermToken(), "desc");
        }

        public void minDocumentCount(int minDocumentCount) {
            this.minDocCount = minDocumentCount;
        }

        public void maxTermCount(int maxTermCount) {
            this.size = maxTermCount;
        }

        @Override
        public ElasticsearchTermsAggregation<F, K> build() {
            return new ElasticsearchTermsAggregation(this);
        }

        protected final void order(String key, String order) {
            JsonObject orderObject = new JsonObject();
            orderObject.addProperty(key, order);
            this.order = orderObject;
        }
    }

    public static class TypeSelector<F> {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchContext searchContext;
        private final ElasticsearchSearchValueFieldContext<F> field;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            this.codec = codec;
            this.searchContext = searchContext;
            this.field = field;
        }

        public <T> Builder<F, T> type(Class<T> expectedType, ValueConvert convert) {
            return new Builder(this.codec, this.searchContext, this.field, this.field.type().projectionConverter(convert).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchFieldQueryElementFactory<TypeSelector<?>, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?> create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            return new TypeSelector(this.codec, searchContext, field);
        }
    }
}

