/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.ExistsPredicateBuilder;

public class ElasticsearchExistsPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor EXISTS_ACCESSOR = JsonAccessor.root().property("exists").asObject();
    private static final JsonAccessor<String> FIELD_ACCESSOR = JsonAccessor.root().property("field").asString();

    private ElasticsearchExistsPredicate(Builder builder) {
        super(builder);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        FIELD_ACCESSOR.set(innerObject, this.absoluteFieldPath);
        EXISTS_ACCESSOR.set(outerObject, innerObject);
        return outerObject;
    }

    public static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements ExistsPredicateBuilder {
        public Builder(ElasticsearchSearchContext searchContext, String absoluteFieldPath, List<String> nestedPathHierarchy) {
            super(searchContext, absoluteFieldPath, nestedPathHierarchy);
        }

        public SearchPredicate build() {
            return new ElasticsearchExistsPredicate(this);
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchSearchFieldQueryElementFactory<ExistsPredicateBuilder, F> {
        @Override
        public ExistsPredicateBuilder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<F> field) {
            return new Builder(searchContext, field.absolutePath(), field.nestedPathHierarchy());
        }
    }
}

