/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.PhrasePredicateBuilder;

public class ElasticsearchTextPhrasePredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor MATCH_PHRASE_ACCESSOR = JsonAccessor.root().property("match_phrase").asObject();
    private static final JsonAccessor<Integer> SLOP_ACCESSOR = JsonAccessor.root().property("slop").asInteger();
    private static final JsonAccessor<JsonElement> QUERY_ACCESSOR = JsonAccessor.root().property("query");
    private static final JsonAccessor<String> ANALYZER_ACCESSOR = JsonAccessor.root().property("analyzer").asString();
    private final Integer slop;
    private final JsonElement phrase;
    private final String analyzer;

    private ElasticsearchTextPhrasePredicate(Builder builder) {
        super(builder);
        this.slop = builder.slop;
        this.phrase = builder.phrase;
        this.analyzer = builder.analyzer;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        QUERY_ACCESSOR.set(innerObject, this.phrase);
        if (this.slop != null) {
            SLOP_ACCESSOR.set(innerObject, this.slop);
        }
        if (this.analyzer != null) {
            ANALYZER_ACCESSOR.set(innerObject, this.analyzer);
        }
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        MATCH_PHRASE_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements PhrasePredicateBuilder {
        private final ElasticsearchSearchValueFieldContext<String> field;
        private Integer slop;
        private JsonElement phrase;
        private String analyzer;

        private Builder(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<String> field) {
            super(searchContext, field);
            this.field = field;
        }

        public void slop(int slop) {
            this.slop = slop;
        }

        public void phrase(String phrase) {
            this.phrase = new JsonPrimitive(phrase);
        }

        public void analyzer(String analyzerName) {
            this.analyzer = analyzerName;
        }

        public void skipAnalysis() {
            this.analyzer("keyword");
        }

        public SearchPredicate build() {
            if (this.analyzer == null) {
                this.field.type().searchAnalyzerName();
                this.field.type().normalizerName();
            }
            return new ElasticsearchTextPhrasePredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchSearchFieldQueryElementFactory<PhrasePredicateBuilder, String> {
        @Override
        public PhrasePredicateBuilder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<String> field) {
            return new Builder(searchContext, field);
        }
    }
}

