/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.predicate.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.search.impl.AbstractElasticsearchSearchFieldQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchContext;
import org.hibernate.search.backend.elasticsearch.search.impl.ElasticsearchSearchValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.spi.WildcardPredicateBuilder;

public class ElasticsearchTextWildcardPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private static final JsonObjectAccessor WILDCARD_ACCESSOR = JsonAccessor.root().property("wildcard").asObject();
    private static final JsonAccessor<JsonElement> VALUE_ACCESSOR = JsonAccessor.root().property("value");
    private final JsonPrimitive pattern;

    public ElasticsearchTextWildcardPredicate(Builder builder) {
        super(builder);
        this.pattern = builder.pattern;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        VALUE_ACCESSOR.set(innerObject, (JsonElement)this.pattern);
        JsonObject middleObject = new JsonObject();
        middleObject.add(this.absoluteFieldPath, (JsonElement)innerObject);
        WILDCARD_ACCESSOR.set(outerObject, middleObject);
        return outerObject;
    }

    private static class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements WildcardPredicateBuilder {
        private JsonPrimitive pattern;

        private Builder(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<String> field) {
            super(searchContext, field);
        }

        public void pattern(String pattern) {
            this.pattern = new JsonPrimitive(pattern);
        }

        public SearchPredicate build() {
            return new ElasticsearchTextWildcardPredicate(this);
        }
    }

    public static class Factory
    extends AbstractElasticsearchSearchFieldQueryElementFactory<WildcardPredicateBuilder, String> {
        @Override
        public WildcardPredicateBuilder create(ElasticsearchSearchContext searchContext, ElasticsearchSearchValueFieldContext<String> field) {
            return new Builder(searchContext, field);
        }
    }
}

