/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.elasticsearch.client.impl.Paths;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.backend.elasticsearch.search.timeout.impl.ElasticsearchTimeoutManager;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.backend.elasticsearch.work.builder.impl.SearchWorkBuilder;
import org.hibernate.search.backend.elasticsearch.work.impl.AbstractNonBulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchSearchResultExtractor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.util.common.logging.impl.DefaultLogCategories;
import org.hibernate.search.util.common.logging.impl.LogCategory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class SearchWork<R>
extends AbstractNonBulkableWork<R> {
    private static final Log queryLog = (Log)LoggerFactory.make(Log.class, (LogCategory)DefaultLogCategories.QUERY);
    private final ElasticsearchSearchResultExtractor<R> resultExtractor;
    private final ElasticsearchTimeoutManager timeoutManager;

    protected SearchWork(Builder<R> builder) {
        super(builder);
        this.resultExtractor = ((Builder)builder).resultExtractor;
        this.timeoutManager = ((Builder)builder).timeoutManager;
    }

    @Override
    protected CompletableFuture<?> beforeExecute(ElasticsearchWorkExecutionContext executionContext, ElasticsearchRequest request) {
        queryLog.executingElasticsearchQuery(request.path(), request.parameters(), executionContext.getGsonProvider().getLogHelper().toString(request.bodyParts()));
        return super.beforeExecute(executionContext, request);
    }

    @Override
    protected R generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
        JsonObject body = response.body();
        return this.resultExtractor.extract(body, this.timeoutManager);
    }

    public static class Builder<R>
    extends AbstractNonBulkableWork.AbstractBuilder<Builder<R>>
    implements SearchWorkBuilder<R> {
        private final JsonObject payload;
        private final ElasticsearchSearchResultExtractor<R> resultExtractor;
        private final boolean allowPartialSearchResultsSupported;
        private final Set<URLEncodedString> indexes = new HashSet<URLEncodedString>();
        private Boolean trackTotalHits;
        private Long totalHitCountThreshold;
        private Integer from;
        private Integer size;
        private Integer scrollSize;
        private String scrollTimeout;
        private Set<String> routingKeys;
        private ElasticsearchTimeoutManager timeoutManager;

        public static <T> Builder<T> forElasticsearch62AndBelow(JsonObject payload, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            return new Builder<T>(payload, resultExtractor, null, false);
        }

        public static <T> Builder<T> forElasticsearch63to68(JsonObject payload, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            return new Builder<T>(payload, resultExtractor, null, false);
        }

        public static <T> Builder<T> forElasticsearch7AndAbove(JsonObject payload, ElasticsearchSearchResultExtractor<T> resultExtractor) {
            return new Builder<T>(payload, resultExtractor, true, false);
        }

        private Builder(JsonObject payload, ElasticsearchSearchResultExtractor<R> resultExtractor, Boolean trackTotalHits, boolean allowPartialSearchResultsSupported) {
            super(DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.payload = payload;
            this.resultExtractor = resultExtractor;
            this.trackTotalHits = trackTotalHits;
            this.allowPartialSearchResultsSupported = allowPartialSearchResultsSupported;
        }

        @Override
        public SearchWorkBuilder<R> index(URLEncodedString indexName) {
            this.indexes.add(indexName);
            return this;
        }

        @Override
        public Builder<R> paging(Integer limit, Integer offset) {
            this.from = offset;
            this.size = limit;
            return this;
        }

        @Override
        public Builder<R> scrolling(int scrollSize, String scrollTimeout) {
            this.scrollSize = scrollSize;
            this.scrollTimeout = scrollTimeout;
            return this;
        }

        @Override
        public SearchWorkBuilder<R> routingKeys(Set<String> routingKeys) {
            this.routingKeys = routingKeys;
            return this;
        }

        @Override
        public SearchWorkBuilder<R> timeout(ElasticsearchTimeoutManager timeoutManager) {
            this.timeoutManager = timeoutManager;
            return this;
        }

        @Override
        public SearchWorkBuilder<R> disableTrackTotalHits() {
            if (this.trackTotalHits != null && this.trackTotalHits.booleanValue()) {
                this.trackTotalHits = false;
            }
            return this;
        }

        @Override
        public SearchWorkBuilder<R> totalHitCountThreshold(Long totalHitCountThreshold) {
            if (this.trackTotalHits != null && this.trackTotalHits.booleanValue()) {
                this.totalHitCountThreshold = totalHitCountThreshold;
            }
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().multiValuedPathComponent(this.indexes).pathComponent(Paths._SEARCH).body(this.payload);
            if (this.from != null) {
                builder.param("from", this.from);
            }
            if (this.size != null) {
                builder.param("size", this.size);
            }
            if (this.scrollSize != null && this.scrollTimeout != null) {
                builder.param("size", this.scrollSize);
                builder.param("scroll", this.scrollTimeout);
            }
            if (this.routingKeys != null && !this.routingKeys.isEmpty()) {
                builder.multiValuedParam("routing", this.routingKeys);
            }
            if (this.trackTotalHits != null) {
                if (this.trackTotalHits.booleanValue() && this.totalHitCountThreshold != null) {
                    builder.param("track_total_hits", this.totalHitCountThreshold);
                } else {
                    builder.param("track_total_hits", this.trackTotalHits);
                }
            }
            if (this.timeoutManager.defined()) {
                builder.param("timeout", this.timeoutManager.timeoutString());
                if (this.allowPartialSearchResultsSupported) {
                    builder.param("allow_partial_search_results", !this.timeoutManager.hasHardTimeout());
                }
                if (this.timeoutManager.hasHardTimeout()) {
                    builder.requestDeadline(this.timeoutManager);
                }
            }
            return builder.build();
        }

        @Override
        public SearchWork<R> build() {
            return new SearchWork(this);
        }
    }
}

