/*
 * Hibernate Search, full-text search for your domain model
 *
 * License: GNU Lesser General Public License (LGPL), version 2.1 or later
 * See the lgpl.txt file in the root directory or <http://www.gnu.org/licenses/lgpl-2.1.html>.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.CompositeProjectionBuilder;


class ElasticsearchCompositeProjectionBuilder<P> implements CompositeProjectionBuilder<P> {

	private final AbstractElasticsearchCompositeProjection<P> projection;

	ElasticsearchCompositeProjectionBuilder(AbstractElasticsearchCompositeProjection<P> projection) {
		this.projection = projection;
	}

	@Override
	public SearchProjection<P> build() {
		return projection;
	}
}
