/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.analysis.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.backend.elasticsearch.analysis.model.esnative.impl.AnalyzerDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.esnative.impl.CharFilterDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.esnative.impl.NormalizerDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.esnative.impl.TokenFilterDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.esnative.impl.TokenizerDefinition;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionCollector;
import org.hibernate.search.backend.elasticsearch.analysis.model.impl.ElasticsearchAnalysisDefinitionContributor;
import org.hibernate.search.backend.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ElasticsearchAnalysisDefinitionRegistry {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final Map<String, AnalyzerDefinition> analyzerDefinitions;
    private final Map<String, NormalizerDefinition> normalizerDefinitions;
    private final Map<String, TokenizerDefinition> tokenizerDefinitions;
    private final Map<String, TokenFilterDefinition> tokenFilterDefinitions;
    private final Map<String, CharFilterDefinition> charFilterDefinitions;

    public ElasticsearchAnalysisDefinitionRegistry() {
        this.analyzerDefinitions = Collections.emptyMap();
        this.normalizerDefinitions = Collections.emptyMap();
        this.tokenizerDefinitions = Collections.emptyMap();
        this.tokenFilterDefinitions = Collections.emptyMap();
        this.charFilterDefinitions = Collections.emptyMap();
    }

    public ElasticsearchAnalysisDefinitionRegistry(ElasticsearchAnalysisDefinitionContributor contributor) {
        this.analyzerDefinitions = new TreeMap<String, AnalyzerDefinition>();
        this.normalizerDefinitions = new TreeMap<String, NormalizerDefinition>();
        this.tokenizerDefinitions = new TreeMap<String, TokenizerDefinition>();
        this.tokenFilterDefinitions = new TreeMap<String, TokenFilterDefinition>();
        this.charFilterDefinitions = new TreeMap<String, CharFilterDefinition>();
        contributor.contribute(new ElasticsearchAnalysisDefinitionCollector(){

            @Override
            public void collect(String name, AnalyzerDefinition definition) {
                AnalyzerDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.analyzerDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw log.analyzerNamingConflict(name);
                }
            }

            @Override
            public void collect(String name, NormalizerDefinition definition) {
                NormalizerDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.normalizerDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw log.normalizerNamingConflict(name);
                }
            }

            @Override
            public void collect(String name, TokenizerDefinition definition) {
                TokenizerDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.tokenizerDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw log.tokenizerNamingConflict(name);
                }
            }

            @Override
            public void collect(String name, TokenFilterDefinition definition) {
                TokenFilterDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.tokenFilterDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw log.tokenFilterNamingConflict(name);
                }
            }

            @Override
            public void collect(String name, CharFilterDefinition definition) {
                CharFilterDefinition previous = ElasticsearchAnalysisDefinitionRegistry.this.charFilterDefinitions.putIfAbsent(name, definition);
                if (previous != null && previous != definition) {
                    throw log.charFilterNamingConflict(name);
                }
            }
        });
    }

    public Map<String, AnalyzerDefinition> getAnalyzerDefinitions() {
        return Collections.unmodifiableMap(this.analyzerDefinitions);
    }

    public Map<String, NormalizerDefinition> getNormalizerDefinitions() {
        return Collections.unmodifiableMap(this.normalizerDefinitions);
    }

    public Map<String, TokenizerDefinition> getTokenizerDefinitions() {
        return Collections.unmodifiableMap(this.tokenizerDefinitions);
    }

    public Map<String, TokenFilterDefinition> getTokenFilterDefinitions() {
        return Collections.unmodifiableMap(this.tokenFilterDefinitions);
    }

    public Map<String, CharFilterDefinition> getCharFilterDefinitions() {
        return Collections.unmodifiableMap(this.charFilterDefinitions);
    }
}

